/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2;

import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.expressionV2.ExpressionConvertVisitor;
import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionFactory;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BooleanValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.DoubleValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.ListValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.LongValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.StringValueExpr;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public final class Expressions {
    private static final String SPLIT_DOTTED = "\\.";

    private Expressions() {
    }

    public static AndExpression and(Collection<IExpression> expressions) {
        if (CollectionUtils.isEmpty(expressions)) {
            return null;
        }
        List<ILogicalExpression> expressionList = expressions.stream().filter(Objects::nonNull).map(Expressions::isILogicalExpression).collect(Collectors.toList());
        return new AndExpression(expressionList);
    }

    private static ILogicalExpression isILogicalExpression(IExpression expression) {
        if (!(expression instanceof ILogicalExpression)) {
            throw new IllegalArgumentException("expression [" + expression + "] is not ILogicalExpression");
        }
        return (ILogicalExpression)expression;
    }

    public static AndExpression and(IExpression ... expressions) {
        if (Objects.isNull(expressions) || expressions.length == 0) {
            return null;
        }
        return Expressions.and(Arrays.asList(expressions));
    }

    public static OrExpression or(IExpression ... expressions) {
        if (Objects.isNull(expressions) || expressions.length == 0) {
            return null;
        }
        return Expressions.or(Arrays.asList(expressions));
    }

    public static OrExpression or(Collection<IExpression> expressions) {
        if (CollectionUtils.isEmpty(expressions)) {
            return null;
        }
        List<ILogicalExpression> expressionList = expressions.stream().filter(Objects::nonNull).map(Expressions::isILogicalExpression).collect(Collectors.toList());
        return new OrExpression(expressionList);
    }

    public static NotExpression not(IExpression expression) {
        if (Objects.isNull(expression)) {
            return null;
        }
        return new NotExpression(Expressions.isILogicalExpression(expression));
    }

    public static MathExpression eq(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.EQ, new StringValueExpr(value));
    }

    public static MathExpression eq(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.EQ, new LongValueExpr(value));
    }

    public static MathExpression eq(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.EQ, new DoubleValueExpr(value));
    }

    public static MathExpression eq(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.EQ, new BooleanValueExpr(value));
    }

    public static MathExpression ne(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.NEQ, new StringValueExpr(value));
    }

    public static MathExpression ne(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.NEQ, new LongValueExpr(value));
    }

    public static MathExpression ne(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.NEQ, new DoubleValueExpr(value));
    }

    public static MathExpression ne(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.NEQ, new BooleanValueExpr(value));
    }

    public static MathExpression gt(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GT, new StringValueExpr(value));
    }

    public static MathExpression gt(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GT, new LongValueExpr(value));
    }

    public static MathExpression gt(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GT, new DoubleValueExpr(value));
    }

    public static MathExpression gt(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GT, new BooleanValueExpr(value));
    }

    public static MathExpression gte(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GTE, new StringValueExpr(value));
    }

    public static MathExpression gte(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GTE, new LongValueExpr(value));
    }

    public static MathExpression gte(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GTE, new DoubleValueExpr(value));
    }

    public static MathExpression gte(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.GTE, new BooleanValueExpr(value));
    }

    public static MathExpression lt(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LT, new StringValueExpr(value));
    }

    public static MathExpression lt(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LT, new LongValueExpr(value));
    }

    public static MathExpression lt(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LT, new DoubleValueExpr(value));
    }

    public static MathExpression lt(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LT, new BooleanValueExpr(value));
    }

    public static MathExpression lte(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LTE, new StringValueExpr(value));
    }

    public static MathExpression lte(@NonNull String field, @NonNull long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LTE, new LongValueExpr(value));
    }

    public static MathExpression lte(@NonNull String field, @NonNull double value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LTE, new DoubleValueExpr(value));
    }

    public static MathExpression lte(@NonNull String field, @NonNull boolean value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MathExpression(Arrays.asList(field.split(SPLIT_DOTTED)), FQLKeyWord.Operator.LTE, new BooleanValueExpr(value));
    }

    public static ExistExpression exist(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new ExistExpression(Arrays.asList(field.split(SPLIT_DOTTED)));
    }

    public static InExpression in(@NonNull String field, @NonNull Collection valueList, @NonNull Class<?> valueClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        if (valueClass == null) {
            throw new NullPointerException("valueClass is marked non-null but is null");
        }
        if (valueClass.equals(String.class)) {
            return Expressions.inValueString(Arrays.asList(field.split(SPLIT_DOTTED)), valueList);
        }
        if (valueClass.equals(Long.class)) {
            return Expressions.inValueLong(Arrays.asList(field.split(SPLIT_DOTTED)), valueList);
        }
        if (valueClass.equals(Double.class)) {
            return Expressions.inValueDouble(Arrays.asList(field.split(SPLIT_DOTTED)), valueList);
        }
        if (valueClass.equals(Boolean.class)) {
            return Expressions.inValueBoolean(Arrays.asList(field.split(SPLIT_DOTTED)), valueList);
        }
        throw new IllegalArgumentException("InExpression do not support class [" + valueClass + "] in Expressions.in(String field, Collection valueList, Class<?> valueClass)");
    }

    private static InExpression inValueString(@NonNull List<String> splitFields, @NonNull Collection<String> valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        List valueExprList = valueList.stream().map(StringValueExpr::new).collect(Collectors.toList());
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    private static InExpression inValueLong(@NonNull List<String> splitFields, @NonNull Collection<Number> valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        List valueExprList = valueList.stream().map(Number::longValue).map(LongValueExpr::new).collect(Collectors.toList());
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    private static InExpression inValueDouble(@NonNull List<String> splitFields, @NonNull Collection<Number> valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        List valueExprList = valueList.stream().map(Number::doubleValue).map(DoubleValueExpr::new).collect(Collectors.toList());
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    private static InExpression inValueBoolean(@NonNull List<String> splitFields, @NonNull Collection<Boolean> valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        List valueExprList = valueList.stream().map(BooleanValueExpr::new).collect(Collectors.toList());
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull String field, String ... valueList) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (String value : valueList) {
            valueExprList.add(new StringValueExpr(value));
        }
        return new InExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull String field, long ... valueList) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (long value : valueList) {
            valueExprList.add(new LongValueExpr(value));
        }
        return new InExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull String field, double ... valueList) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (double value : valueList) {
            valueExprList.add(new DoubleValueExpr(value));
        }
        return new InExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull String field, boolean ... valueList) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (boolean value : valueList) {
            valueExprList.add(new BooleanValueExpr(value));
        }
        return new InExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new ListValueExpr(valueExprList));
    }

    public static IsNullExpression isNull(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new IsNullExpression(Arrays.asList(field.split(SPLIT_DOTTED)), true);
    }

    public static IsNullExpression isNotNull(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new IsNullExpression(Arrays.asList(field.split(SPLIT_DOTTED)), false);
    }

    public static LikeExpression like(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new LikeExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new StringValueExpr(value));
    }

    public static RLikeExpression rlike(@NonNull String field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new RLikeExpression(Arrays.asList(field.split(SPLIT_DOTTED)), new StringValueExpr(value));
    }

    public static MathExpression eq(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.EQ, new StringValueExpr(value));
    }

    public static MathExpression eq(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.EQ, new LongValueExpr(value));
    }

    public static MathExpression eq(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.EQ, new DoubleValueExpr(value));
    }

    public static MathExpression eq(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.EQ, new BooleanValueExpr(value));
    }

    public static MathExpression ne(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.NEQ, new StringValueExpr(value));
    }

    public static MathExpression ne(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.NEQ, new LongValueExpr(value));
    }

    public static MathExpression ne(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.NEQ, new DoubleValueExpr(value));
    }

    public static MathExpression ne(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.NEQ, new BooleanValueExpr(value));
    }

    public static MathExpression gt(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GT, new StringValueExpr(value));
    }

    public static MathExpression gt(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GT, new LongValueExpr(value));
    }

    public static MathExpression gt(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GT, new DoubleValueExpr(value));
    }

    public static MathExpression gt(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GT, new BooleanValueExpr(value));
    }

    public static MathExpression gte(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GTE, new StringValueExpr(value));
    }

    public static MathExpression gte(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GTE, new LongValueExpr(value));
    }

    public static MathExpression gte(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GTE, new DoubleValueExpr(value));
    }

    public static MathExpression gte(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.GTE, new BooleanValueExpr(value));
    }

    public static MathExpression lt(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LT, new StringValueExpr(value));
    }

    public static MathExpression lt(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LT, new LongValueExpr(value));
    }

    public static MathExpression lt(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LT, new DoubleValueExpr(value));
    }

    public static MathExpression lt(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LT, new BooleanValueExpr(value));
    }

    public static MathExpression lte(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LTE, new StringValueExpr(value));
    }

    public static MathExpression lte(@NonNull List<String> splitFields, @NonNull long value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LTE, new LongValueExpr(value));
    }

    public static MathExpression lte(@NonNull List<String> splitFields, @NonNull double value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LTE, new DoubleValueExpr(value));
    }

    public static MathExpression lte(@NonNull List<String> splitFields, @NonNull boolean value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new MathExpression(splitFields, FQLKeyWord.Operator.LTE, new BooleanValueExpr(value));
    }

    public static ExistExpression exist(@NonNull List<String> splitFields) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new ExistExpression(splitFields);
    }

    public static InExpression in(@NonNull List<String> splitFields, @NonNull Collection valueList, @NonNull Class<?> valueClass) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        if (valueClass == null) {
            throw new NullPointerException("valueClass is marked non-null but is null");
        }
        if (valueClass.equals(String.class)) {
            return Expressions.inValueString(splitFields, valueList);
        }
        if (valueClass.equals(Long.class)) {
            return Expressions.inValueLong(splitFields, valueList);
        }
        if (valueClass.equals(Double.class)) {
            return Expressions.inValueDouble(splitFields, valueList);
        }
        if (valueClass.equals(Boolean.class)) {
            return Expressions.inValueBoolean(splitFields, valueList);
        }
        throw new IllegalArgumentException("InExpression do not support class [" + valueClass + "] in Expressions.in(List<String> splitFields, Collection valueList, Class<?> valueClass)");
    }

    public static InExpression in(@NonNull List<String> splitFields, String ... valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (String value : valueList) {
            valueExprList.add(new StringValueExpr(value));
        }
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull List<String> splitFields, long ... valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (long value : valueList) {
            valueExprList.add(new LongValueExpr(value));
        }
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull List<String> splitFields, double ... valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (double value : valueList) {
            valueExprList.add(new DoubleValueExpr(value));
        }
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    public static InExpression in(@NonNull List<String> splitFields, boolean ... valueList) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (valueList == null) {
            throw new NullPointerException("valueList is marked non-null but is null");
        }
        ArrayList valueExprList = Lists.newArrayList();
        for (boolean value : valueList) {
            valueExprList.add(new BooleanValueExpr(value));
        }
        return new InExpression(splitFields, new ListValueExpr(valueExprList));
    }

    public static IsNullExpression isNull(@NonNull List<String> splitFields) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new IsNullExpression(splitFields, true);
    }

    public static IsNullExpression isNotNull(@NonNull List<String> splitFields) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        return new IsNullExpression(splitFields, false);
    }

    public static LikeExpression like(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new LikeExpression(splitFields, new StringValueExpr(value));
    }

    public static RLikeExpression rlike(@NonNull List<String> splitFields, @NonNull String value) {
        if (splitFields == null) {
            throw new NullPointerException("splitFields is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new RLikeExpression(splitFields, new StringValueExpr(value));
    }

    public static MathExpression eq(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.EQ, valueFunc, implClass);
    }

    public static MathExpression ne(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.NEQ, valueFunc, implClass);
    }

    public static MathExpression gt(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.GT, valueFunc, implClass);
    }

    public static MathExpression gte(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.GTE, valueFunc, implClass);
    }

    public static MathExpression lt(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.LT, valueFunc, implClass);
    }

    public static MathExpression lte(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return Expressions.getFuncExpr(field, FQLKeyWord.Operator.LTE, valueFunc, implClass);
    }

    public static InExpression in(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        String fql = field + " in " + valueFunc;
        InExpression expression = (InExpression)ExpressionConvertVisitor.parse(fql);
        if (!(expression.getValueList() instanceof FunctionExpression)) {
            throw new IllegalArgumentException("valueFunc: " + valueFunc + " is not a function");
        }
        FunctionFactory.registerFunc(((FunctionExpression)expression.getValueList()).getName(), implClass);
        return expression;
    }

    public static LikeExpression like(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        String fql = field + " like " + valueFunc;
        LikeExpression expression = (LikeExpression)ExpressionConvertVisitor.parse(fql);
        if (!(expression.getValue() instanceof FunctionExpression)) {
            throw new IllegalArgumentException("valueFunc: " + valueFunc + " is not a function");
        }
        FunctionFactory.registerFunc(((FunctionExpression)expression.getValue()).getName(), implClass);
        return expression;
    }

    public static RLikeExpression rlike(@NonNull String field, @NonNull String valueFunc, Class<?> implClass) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        String fql = field + " rlike " + valueFunc;
        RLikeExpression expression = (RLikeExpression)ExpressionConvertVisitor.parse(fql);
        if (!(expression.getValue() instanceof FunctionExpression)) {
            throw new IllegalArgumentException("valueFunc: " + valueFunc + " is not a function");
        }
        FunctionFactory.registerFunc(((FunctionExpression)expression.getValue()).getName(), implClass);
        return expression;
    }

    private static MathExpression getFuncExpr(String field, FQLKeyWord.Operator operator, String valueFunc, Class<?> implClass) {
        String fql = field + " " + operator.getLiteral() + " " + valueFunc;
        MathExpression expression = (MathExpression)ExpressionConvertVisitor.parse(fql);
        if (!(expression.getValue() instanceof FunctionExpression)) {
            throw new IllegalArgumentException("valueFunc: " + valueFunc + " is not a function");
        }
        FunctionFactory.registerFunc(((FunctionExpression)expression.getValue()).getName(), implClass);
        return expression;
    }
}

