/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.listener;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public class FQLErrorListener
extends BaseErrorListener {
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bos);
            writer.print("you have syntax error at " + line + "." + charPositionInLine + ":" + msg);
            Token token = (Token)offendingSymbol;
            if (e instanceof InputMismatchException) {
                writer.print(",but found ");
                writer.println(recognizer.getVocabulary().getDisplayName(token.getType()));
            } else {
                writer.println();
            }
            this.underlineError(writer, recognizer, token, line, charPositionInLine);
            writer.flush();
            String errMsg = new String(bos.toByteArray());
            throw new FQLGrammarException(errMsg);
        }
        catch (Exception ee) {
            throw new FQLGrammarException(ee.getMessage());
        }
    }

    protected void underlineError(PrintWriter writer, Recognizer recognizer, Token offendingToken, int line, int charPositionInLine) {
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        String input = tokens.getTokenSource().getInputStream().toString();
        String[] lines = input.split("\n");
        String errorLine = lines[line - 1];
        writer.println(errorLine);
        for (int i = 0; i < charPositionInLine; ++i) {
            writer.print(" ");
        }
        int start = offendingToken.getStartIndex();
        int stop = offendingToken.getStopIndex();
        if (start >= 0 && stop >= 0) {
            for (int i = start; i <= stop; ++i) {
                writer.print("^");
            }
        }
    }
}

