/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.logical;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionFactory;
import com.envisioniot.enos.api.framework.expr.expressionV2.visitor.IExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Set;

@JsonTypeName(value="FunctionExpression")
@JSONType(serialzeFeatures={SerializerFeature.WriteClassName})
public class FunctionExpression
implements ILogicalExpression,
IValueExpression<Object> {
    String name;
    List<IValueExpression> args;

    @Override
    @JSONField(serialize=false)
    public FQLKeyWord.ValueType getType() {
        Class<?> returnClass = FunctionFactory.getReturnType(this.name, this.args);
        if (returnClass.equals(String.class) || returnClass.equals(String[].class)) {
            return FQLKeyWord.ValueType.STRING;
        }
        if (returnClass.equals(Long.class) || returnClass.equals(Long[].class) || returnClass.equals(Integer.class) || returnClass.equals(Integer[].class) || returnClass.equals(Byte.class) || returnClass.equals(Byte[].class) || returnClass.equals(Short.class) || returnClass.equals(Short[].class)) {
            return FQLKeyWord.ValueType.LONG;
        }
        if (returnClass.equals(Double.class) || returnClass.equals(Double[].class) || returnClass.equals(Float.class) || returnClass.equals(Float[].class)) {
            return FQLKeyWord.ValueType.DOUBLE;
        }
        if (returnClass.equals(Boolean.class) || returnClass.equals(Boolean[].class)) {
            return FQLKeyWord.ValueType.BOOLEAN;
        }
        if (returnClass.equals(Date.class) || returnClass.equals(Date[].class)) {
            return FQLKeyWord.ValueType.DATE;
        }
        throw new FQLGrammarException("the type: " + returnClass + " returned by the method: " + this.name + " is not supported");
    }

    @Override
    @JSONField(serialize=false)
    public Set<String> getFields() {
        return ImmutableSet.of();
    }

    @Override
    public Object getValue() {
        return FunctionFactory.call(this.name, this.args);
    }

    @Override
    public <T> T accept(IExpressionVisitor<? extends T> visitor) {
        return visitor.visitFunctionExpression(this);
    }

    public String toString() {
        return "FunctionExpression(name = " + this.name + "args = " + this.args + ")";
    }

    public String getName() {
        return this.name;
    }

    public List<IValueExpression> getArgs() {
        return this.args;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgs(List<IValueExpression> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionExpression)) {
            return false;
        }
        FunctionExpression other = (FunctionExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<IValueExpression> this$args = this.getArgs();
        List<IValueExpression> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<IValueExpression> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public FunctionExpression() {
    }

    public FunctionExpression(String name, List<IValueExpression> args) {
        this.name = name;
        this.args = args;
    }
}

