/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.logical;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public abstract class FunctionFactory {
    private static final Map<String, List<Class<?>>> funcMap = Maps.newConcurrentMap();

    public static void registerFunc(String name, Class<?> implClass) {
        if (funcMap.containsKey(name)) {
            if (!funcMap.get(name).contains(implClass)) {
                funcMap.get(name).add(implClass);
            }
        } else {
            funcMap.put(name, Lists.newArrayList((Object[])new Class[]{implClass}));
        }
    }

    public static List<Class<?>> getFuncType(String funcName) {
        if (funcMap.containsKey(funcName)) {
            return funcMap.get(funcName);
        }
        throw new FQLGrammarException("this method: " + funcName + " is not currently supported");
    }

    public static Object call(String funcName, List<IValueExpression> args) {
        Class[] argClasses = null;
        Object[] argArray = null;
        List<Class<?>> funcTypes = FunctionFactory.getFuncType(funcName);
        if (args != null) {
            argClasses = (Class[])args.stream().map(Object::getClass).toArray(Class[]::new);
            argArray = args.toArray();
        }
        for (Class<?> funcType : funcTypes) {
            try {
                Method method = funcType.getMethod(funcName, argClasses);
                return method.invoke(funcType, argArray);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        throw new FQLGrammarException("method: [" + funcName + "] input parameter list is inconsistent");
    }

    public static Class<?> getReturnType(String funcName, List<IValueExpression> args) {
        Class[] argClasses = null;
        List<Class<?>> funcTypes = FunctionFactory.getFuncType(funcName);
        if (args != null) {
            argClasses = (Class[])args.stream().map(Object::getClass).toArray(Class[]::new);
        }
        for (Class<?> funcType : funcTypes) {
            try {
                Method method = funcType.getMethod(funcName, argClasses);
                return method.getReturnType();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new FQLGrammarException("method: [" + funcName + "] input parameter list is inconsistent");
    }
}

