/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.util;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.util.FQLConvertUtil;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BasePrimitiveValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.ListValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.StringValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.visitor.IExpressionVisitor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpressionFQLStringVisitor
implements IExpressionVisitor<String> {
    private static final String REVERSE_QUOTE = "`";
    private static final String SPLIT_DOTTED = "\\.";
    private static final String DOTTED = ".";
    private static final String SINGLE_QUOTA = "'";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String AND_SYMBOL = " && ";
    private static final String OR_SYMBOL = " || ";
    private static final String COMMA = ", ";

    public static String parse(IExpression expression) {
        if (expression instanceof ILogicalExpression) {
            ExpressionFQLStringVisitor visitor = new ExpressionFQLStringVisitor();
            String result = (String)visitor.visitILogicalExpression((ILogicalExpression)expression);
            result = result.length() >= 2 && result.charAt(0) == '(' && result.charAt(result.length() - 1) == ')' ? result.substring(1, result.length() - 1) : result;
            return result;
        }
        throw new FQLGrammarException("expression must be instance of ILogicalExpression, expression : " + expression);
    }

    @Override
    public String visitAndExpression(AndExpression expression) {
        List<ILogicalExpression> expressionList = expression.getExpressionList();
        if (CollectionUtils.isEmpty(expressionList)) {
            return expressionList + "";
        }
        String sb = expressionList.stream().map(this::visitILogicalExpression).collect(Collectors.joining(AND_SYMBOL));
        return sb.length() > 0 ? LEFT_PARENTHESIS + sb + RIGHT_PARENTHESIS : "";
    }

    @Override
    public String visitExistExpression(ExistExpression expression) {
        return "exists ( " + this.getFQLField(expression.getSplitFields()) + " )";
    }

    @Override
    public String visitFunctionExpression(FunctionExpression expression) {
        String argsString = "";
        if (CollectionUtils.isNotEmpty(expression.getArgs())) {
            argsString = expression.getArgs().stream().map(arg -> {
                if (arg instanceof ListValueExpr) {
                    return "Array" + this.getListString(this.visitListValue((ListValueExpr)arg));
                }
                if (arg instanceof BasePrimitiveValueExpr) {
                    return this.visitPrimitiveValue((BasePrimitiveValueExpr)arg) + "";
                }
                if (arg == null) {
                    return "null";
                }
                throw new FQLGrammarException("function expression do not support " + arg.getClass() + ",  expression : " + expression);
            }).collect(Collectors.joining(COMMA));
        }
        return expression.getName() + LEFT_PARENTHESIS + argsString + RIGHT_PARENTHESIS;
    }

    @Override
    public String visitInExpression(InExpression expression) {
        String field = this.getFQLField(expression.getSplitFields());
        IValueExpression values = expression.getValueList();
        if (values instanceof ListValueExpr) {
            return field + " in " + this.getListString(this.visitListValue((ListValueExpr)values));
        }
        if (values instanceof FunctionExpression) {
            return field + " in " + this.visitValueFunction((FunctionExpression)values);
        }
        throw new FQLGrammarException("expression parameter error, expression : " + expression);
    }

    @Override
    public String visitIsNullExpression(IsNullExpression expression) {
        String field = this.getFQLField(expression.getSplitFields());
        return expression.isNull() ? field + " is null" : field + " is not null";
    }

    @Override
    public String visitLikeExpression(LikeExpression expression) {
        String field = this.getFQLField(expression.getSplitFields());
        IValueExpression value = expression.getValue();
        if (value instanceof StringValueExpr || value instanceof FunctionExpression) {
            return field + " like " + this.visitIValueExpression(value);
        }
        throw new FQLGrammarException("expression parameter error, expression : " + expression);
    }

    @Override
    public String visitMathExpression(MathExpression expression) {
        String field = this.getFQLField(expression.getSplitFields());
        String op = expression.getOp().getLiteral();
        IValueExpression value = expression.getValue();
        if (value instanceof BasePrimitiveValueExpr || value instanceof FunctionExpression) {
            return field + " " + op + " " + this.visitIValueExpression(value);
        }
        throw new FQLGrammarException("expression parameter error, expression : " + expression);
    }

    @Override
    public String visitNotExpression(NotExpression expression) {
        if (Objects.isNull(expression.getExpression())) {
            return "! " + null;
        }
        return "! " + (String)this.visitILogicalExpression(expression.getExpression());
    }

    @Override
    public String visitOrExpression(OrExpression expression) {
        List<ILogicalExpression> expressionList = expression.getExpressionList();
        if (Objects.isNull(expressionList) || expressionList.size() == 0) {
            return expressionList + "";
        }
        String sb = expressionList.stream().map(this::visitILogicalExpression).collect(Collectors.joining(OR_SYMBOL));
        return sb.length() > 0 ? LEFT_PARENTHESIS + sb + RIGHT_PARENTHESIS : "";
    }

    @Override
    public String visitRLikeExpression(RLikeExpression expression) {
        String field = this.getFQLField(expression.getSplitFields());
        IValueExpression value = expression.getValue();
        if (value instanceof StringValueExpr || value instanceof FunctionExpression) {
            return field + " rlike " + this.visitIValueExpression(value);
        }
        throw new FQLGrammarException("expression parameter error, expression : " + expression);
    }

    @Override
    public String visitValueFunction(FunctionExpression expression) {
        return (String)this.visitILogicalExpression(expression);
    }

    @Override
    public Object visitPrimitiveValue(BasePrimitiveValueExpr expression) {
        Object result = expression instanceof StringValueExpr ? FQLConvertUtil.escapeFQL(((StringValueExpr)expression).getValue()) : expression.getValue();
        return result instanceof String ? SINGLE_QUOTA + result + SINGLE_QUOTA : result;
    }

    private String getFQLField(List<String> splitField) {
        if (CollectionUtils.isEmpty(splitField)) {
            return null;
        }
        Function<String, String> mapper = field -> {
            if (StringUtils.isNotEmpty((CharSequence)field) && field.contains(DOTTED)) {
                return REVERSE_QUOTE + field + REVERSE_QUOTE;
            }
            return field;
        };
        return splitField.stream().map(mapper).collect(Collectors.joining(DOTTED));
    }

    private String getListString(List<Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        return LEFT_PARENTHESIS + values.stream().map(Object::toString).collect(Collectors.joining(COMMA)) + RIGHT_PARENTHESIS;
    }
}

