/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.util;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.ExpressionConvertVisitor;
import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.util.ExpressionFQLStringVisitor;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;

public class FQLConvertUtil {
    public static final char RIGHT_SLASH = '\\';
    public static final char DOUBLE_QUOTES = '\"';
    public static final char SINGLE_QUOTES = '\'';

    public static String unescapeFQL(String fql) {
        if (Objects.isNull(fql)) {
            throw new FQLGrammarException("expression string value is null");
        }
        boolean doubleSlash = false;
        StringBuilder result = new StringBuilder();
        for (char ch : fql.toCharArray()) {
            if (ch != '\\') {
                result.append(ch);
                doubleSlash = false;
                continue;
            }
            if (doubleSlash) {
                result.append('\\');
                doubleSlash = false;
                continue;
            }
            doubleSlash = true;
        }
        return result.toString();
    }

    public static String escapeFQL(String fql) {
        if (Objects.isNull(fql)) {
            throw new FQLGrammarException("expression string value is null");
        }
        StringBuilder result = new StringBuilder();
        for (char ch : fql.toCharArray()) {
            if (ch == '\\' || ch == '\"' || ch == '\'') {
                result.append('\\');
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static IExpression fromJson(String json) {
        return FQLAndJsonConvert.fromJson(json);
    }

    public static String toJson(IExpression expression) {
        return FQLAndJsonConvert.toJson(expression);
    }

    public static IExpression fromFQLString(String fql) {
        return ExpressionConvertVisitor.parse(fql);
    }

    public static String toFQLString(IExpression expression) {
        return ExpressionFQLStringVisitor.parse(expression);
    }

    public static class FQLAndJsonConvert {
        private static final ObjectMapper MAPPER = new ObjectMapper();

        public static IExpression fromJson(String json) {
            try {
                return (IExpression)MAPPER.readValue(json, IExpression.class);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }

        public static String toJson(IExpression expression) {
            try {
                return MAPPER.writeValueAsString((Object)expression);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }

        static {
            MAPPER.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
            MAPPER.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
            MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        }
    }
}

