/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.util;

import com.envisioniot.enos.api.framework.expr.ExpressionBaseVisitor;
import com.envisioniot.enos.api.framework.expr.IFQLExpression;
import com.envisioniot.enos.api.framework.expr.constant.FQLBooleanValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLDoubleValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.constant.FQLListValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLocalTimeValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLLongValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLStringValue;
import com.envisioniot.enos.api.framework.expr.constant.FQLUTCTimeValue;
import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expression.FQLInExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLIsNullExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLikeExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLogicalExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLLogicalListExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLMathExpr;
import com.envisioniot.enos.api.framework.expr.expression.FQLRLikeExpression;
import com.envisioniot.enos.api.framework.expr.expression.FQLUnaryExpr;
import com.envisioniot.enos.api.framework.expr.expression.FqlExistExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BasePrimitiveValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BooleanValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.DoubleValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.ListValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.LocalTimeValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.LongValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.StringValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.UTCTimeValueExpr;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class OldFQLToNewFQLVisitor
extends ExpressionBaseVisitor<IExpression> {
    private static final String FIELD_SEPARATOR = "\\.";

    public static IExpression parse(IFQLExpression expression) {
        OldFQLToNewFQLVisitor visitor = new OldFQLToNewFQLVisitor();
        return visitor.visitIFQLExpression(expression);
    }

    @Override
    public IExpression visitIFQLExpression(IFQLExpression expression) {
        return (IExpression)super.visitIFQLExpression(expression);
    }

    @Override
    public IExpression visitInExpression(FQLInExpr expression) {
        return new InExpression(this.split(expression.getField()), (IValueExpression)this.visitIFQLExpression(expression.getValues()));
    }

    @Override
    public IExpression visitFQLIsNullExpr(FQLIsNullExpr expression) {
        return new IsNullExpression(this.split(expression.getField()), expression.getIsNull());
    }

    @Override
    public IExpression visitFQLLikeExpr(FQLLikeExpr expression) {
        return new LikeExpression(this.split(expression.getField()), new StringValueExpr(expression.getValue()));
    }

    @Override
    public IExpression visitFQLExistExpr(FqlExistExpr expression) {
        return new ExistExpression(this.split(expression.getField()));
    }

    @Override
    public IExpression visitFQLLogicalExpr(FQLLogicalExpr expression) {
        ILogicalExpression leftExpr = (ILogicalExpression)this.visitIFQLExpression(expression.getLeftExpr());
        ILogicalExpression rightExpr = (ILogicalExpression)this.visitIFQLExpression(expression.getRightExpr());
        ArrayList listExpr = Lists.newArrayList((Object[])new ILogicalExpression[]{leftExpr, rightExpr});
        return expression.getExprOp() == FQLKeyWord.BinaryOperator.AND ? new AndExpression(listExpr) : new OrExpression(listExpr);
    }

    @Override
    public IExpression visitFQLLogicalListExpr(FQLLogicalListExpr expression) {
        List<ILogicalExpression> listExpr = expression.getList().stream().map(expr -> (ILogicalExpression)this.visitIFQLExpression((IFQLExpression)expr)).collect(Collectors.toList());
        return expression.getExprOp() == FQLKeyWord.BinaryOperator.AND ? new AndExpression(listExpr) : new OrExpression(listExpr);
    }

    @Override
    public IExpression visitFQLMathExpr(FQLMathExpr expression) {
        return new MathExpression(this.split(expression.getField()), expression.getOp(), (IValueExpression)this.visitIFQLExpression(expression.getValue()));
    }

    @Override
    public IExpression visitFQLRLikeExpression(FQLRLikeExpression expression) {
        return new RLikeExpression(this.split(expression.getField()), new StringValueExpr(expression.getValue()));
    }

    @Override
    public IExpression visitFQLUnaryExpr(FQLUnaryExpr expression) {
        if ("not".equalsIgnoreCase(expression.getOp()) || "!".equalsIgnoreCase(expression.getOp())) {
            return new NotExpression((ILogicalExpression)this.visitIFQLExpression(expression.getExpr()));
        }
        throw new FQLGrammarException("FQLUnaryExpr do not support op: " + expression.getOp());
    }

    @Override
    public IExpression visitFQLLongValue(FQLLongValue expression) {
        return new LongValueExpr(expression.getValue());
    }

    @Override
    public IExpression visitFQLBooleanValue(FQLBooleanValue expression) {
        return new BooleanValueExpr(expression.getValue());
    }

    @Override
    public IExpression visitFQLDoubleValue(FQLDoubleValue expression) {
        return new DoubleValueExpr(expression.getValue());
    }

    @Override
    public IExpression visitFQLListValue(FQLListValue expression) {
        List values = expression.getList().stream().map(expr -> (BasePrimitiveValueExpr)this.visitIFQLExpression((IFQLExpression)expr)).collect(Collectors.toList());
        return new ListValueExpr(values);
    }

    @Override
    public IExpression visitFQLLocalTimeValue(FQLLocalTimeValue expression) {
        return new LocalTimeValueExpr(expression.getLocalTime(), expression.getLocalDate());
    }

    @Override
    public IExpression visitFQLStringValue(FQLStringValue expression) {
        return new StringValueExpr(expression.getValue());
    }

    @Override
    public IExpression visitFQLUTCTimeValue(FQLUTCTimeValue expression) {
        long time = expression.getTimestamp();
        return new UTCTimeValueExpr(this.toUTC(time), time);
    }

    private List<String> split(String field) {
        return Arrays.asList(field.split(FIELD_SEPARATOR));
    }

    private String toUTC(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }
}

