/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.expressionV2.visitor;

import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.IValueExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.BasePrimitiveValueExpr;
import com.envisioniot.enos.api.framework.expr.expressionV2.value.ListValueExpr;
import java.util.List;
import java.util.stream.Collectors;

public interface IExpressionVisitor<T> {
    default public T visitILogicalExpression(ILogicalExpression expression) {
        return expression.accept(this);
    }

    public T visitAndExpression(AndExpression var1);

    public T visitExistExpression(ExistExpression var1);

    public T visitFunctionExpression(FunctionExpression var1);

    public T visitInExpression(InExpression var1);

    public T visitIsNullExpression(IsNullExpression var1);

    public T visitLikeExpression(LikeExpression var1);

    public T visitMathExpression(MathExpression var1);

    public T visitNotExpression(NotExpression var1);

    public T visitOrExpression(OrExpression var1);

    public T visitRLikeExpression(RLikeExpression var1);

    default public Object visitIValueExpression(IValueExpression expression) {
        if (expression instanceof ListValueExpr) {
            return this.visitListValue((ListValueExpr)expression);
        }
        if (expression instanceof BasePrimitiveValueExpr) {
            return this.visitPrimitiveValue((BasePrimitiveValueExpr)expression);
        }
        if (expression instanceof FunctionExpression) {
            return this.visitValueFunction((FunctionExpression)expression);
        }
        throw new IllegalArgumentException("expression type is not support");
    }

    default public Object visitValueFunction(FunctionExpression expression) {
        return expression.getValue();
    }

    default public <V> V visitPrimitiveValue(BasePrimitiveValueExpr<V> expression) {
        return expression.getValue();
    }

    default public <V, P extends BasePrimitiveValueExpr<V>> List<V> visitListValue(ListValueExpr<P> expression) {
        return expression.getValue().stream().map(this::visitPrimitiveValue).collect(Collectors.toList());
    }
}

