/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.extension.flatten;

import com.envisioniot.enos.api.framework.expr.exception.FQLGrammarException;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.visitor.IExpressionVisitor;
import com.envisioniot.enos.api.framework.expr.extension.flatten.ExprBranch;
import com.envisioniot.enos.api.framework.expr.extension.flatten.ExprBranches;
import com.envisioniot.enos.api.framework.expr.extension.flatten.FieldExprWrapper;
import com.envisioniot.enos.api.framework.expr.extension.flatten.TooManyBranchesException;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.ExistFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.FieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.InFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.IsNullFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.LikeFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.MathFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.RLikeFieldExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExprBranchVisitor
implements IExpressionVisitor<ExprBranches> {
    private static final int DEFAULT_MAX_BRANCHES = 256;
    private final int maxAllowedBranches;

    public ExprBranchVisitor() {
        this(256);
    }

    public ExprBranchVisitor(int maxAllowedBranches) {
        this.maxAllowedBranches = maxAllowedBranches;
    }

    @Override
    public ExprBranches visitAndExpression(AndExpression expression) {
        List<ILogicalExpression> expressions = expression.getExpressionList();
        List<ExprBranches> branches = expressions.stream().map(this::visitILogicalExpression).collect(Collectors.toList());
        int branchCount = this.getFinalBranchCount(branches, false);
        if (branchCount > this.maxAllowedBranches) {
            this.throwTooManyBranchesError();
        }
        return ExprBranches.and(branches.stream());
    }

    @Override
    public ExprBranches visitExistExpression(ExistExpression expression) {
        return this.convert(new ExistFieldExpr(expression.getFieldString()), false);
    }

    @Override
    public ExprBranches visitFunctionExpression(FunctionExpression expression) {
        throw new FQLGrammarException("do not support function");
    }

    @Override
    public ExprBranches visitInExpression(InExpression expression) {
        List values = (List)this.visitIValueExpression(expression.getValueList());
        return this.convert(new InFieldExpr(expression.getFieldString(), values), false);
    }

    @Override
    public ExprBranches visitIsNullExpression(IsNullExpression expression) {
        return this.convert(new IsNullFieldExpr(expression.getFieldString()), !expression.isNull());
    }

    @Override
    public ExprBranches visitLikeExpression(LikeExpression expression) {
        return this.convert(new LikeFieldExpr(expression.getFieldString(), (String)this.visitIValueExpression(expression.getValue())), false);
    }

    @Override
    public ExprBranches visitMathExpression(MathExpression expression) {
        Object value = this.visitIValueExpression(expression.getValue());
        return this.convert(new MathFieldExpr(expression.getFieldString(), expression.getOp(), value), false);
    }

    @Override
    public ExprBranches visitNotExpression(NotExpression expression) {
        ExprBranches branches = (ExprBranches)this.visitILogicalExpression(expression.getExpression());
        return ExprBranches.not(branches);
    }

    @Override
    public ExprBranches visitOrExpression(OrExpression expression) {
        List<ILogicalExpression> expressions = expression.getExpressionList();
        List<ExprBranches> branches = expressions.stream().map(this::visitILogicalExpression).collect(Collectors.toList());
        int branchCount = this.getFinalBranchCount(branches, true);
        if (branchCount > this.maxAllowedBranches) {
            this.throwTooManyBranchesError();
        }
        return ExprBranches.or(branches.stream());
    }

    @Override
    public ExprBranches visitRLikeExpression(RLikeExpression expression) {
        return this.convert(new RLikeFieldExpr(expression.getFieldString(), (String)this.visitIValueExpression(expression.getValue())), false);
    }

    private int getFinalBranchCount(List<ExprBranches> branchesList, boolean isOr) {
        if (isOr) {
            return branchesList.stream().mapToInt(ArrayList::size).sum();
        }
        int result = 1;
        for (ExprBranches branches : branchesList) {
            result *= branches.size();
        }
        return result;
    }

    private ExprBranches convert(FieldExpr expr, boolean isNot) {
        FieldExprWrapper wrapper = new FieldExprWrapper(expr);
        if (isNot) {
            wrapper = wrapper.negate();
        }
        ExprBranches branches = new ExprBranches();
        branches.add(new ExprBranch(wrapper));
        return branches;
    }

    private void throwTooManyBranchesError() {
        throw new TooManyBranchesException("Too many FQL branches, max allowed " + this.maxAllowedBranches);
    }
}

