/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.extension.flatten;

import com.envisioniot.enos.api.framework.expr.extension.flatten.ExprBranch;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ExprBranches
extends ArrayList<ExprBranch> {
    private static final ExprBranches EMPTY = new ExprBranches();

    @Override
    public String toString() {
        return StringUtils.join((Iterable)this, (String)" or ");
    }

    public static ExprBranches and(Stream<ExprBranches> stream) {
        return stream.reduce((lbranches, rbranches) -> {
            ExprBranches merged = new ExprBranches();
            for (ExprBranch lbranch : lbranches) {
                for (ExprBranch rbranch : rbranches) {
                    merged.add(ExprBranches.and(lbranch, rbranch));
                }
            }
            return merged;
        }).orElse(EMPTY);
    }

    public static ExprBranches or(Stream<ExprBranches> stream) {
        ExprBranches result = new ExprBranches();
        stream.forEach(result::addAll);
        return result;
    }

    public static ExprBranches not(ExprBranches branches) {
        return ExprBranches.and(branches.stream().map(ExprBranches::not));
    }

    private static ExprBranch and(ExprBranch ... branches) {
        ExprBranch merged = new ExprBranch();
        for (ExprBranch branch : branches) {
            merged.addAll(branch);
        }
        return merged;
    }

    private static ExprBranches not(ExprBranch branch) {
        ExprBranches branches = new ExprBranches();
        branch.forEach((? super E expr) -> branches.add(new ExprBranch(expr.negate())));
        return branches;
    }
}

