/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.extension.queryplan;

import com.envisioniot.enos.api.framework.expr.constant.FQLKeyWord;
import com.envisioniot.enos.api.framework.expr.extension.flatten.ExprBranches;
import com.envisioniot.enos.api.framework.expr.extension.flatten.FieldExprWrapper;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.FieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.InFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.flatten.fieldexpr.MathFieldExpr;
import com.envisioniot.enos.api.framework.expr.extension.queryplan.Index;
import com.envisioniot.enos.api.framework.expr.extension.queryplan.QueryFields;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;

public class IndexPlanner {
    public static final IndexPlanner INSTANCE = new IndexPlanner();

    public Set<Index> getCoveringIndices(List<Index> indices, ExprBranches branches) {
        Set<QueryFields> queryFieldsSet = this.getQueryFields(branches);
        return this.getMatchedIndices(indices, queryFieldsSet, this::getCoveringIndex);
    }

    public Set<Index> getCoveredKeyIndices(List<Index> keyIndices, ExprBranches branches) {
        Set<QueryFields> keyQueryFieldsSet = this.getCandidateFieldsForKeyIndex(branches);
        if (keyQueryFieldsSet.stream().anyMatch(q -> q.getFields().isEmpty())) {
            return Collections.emptySet();
        }
        return this.getMatchedIndices(keyIndices, keyQueryFieldsSet, this::getKeyIndex);
    }

    private Set<Index> getMatchedIndices(List<Index> indices, Set<QueryFields> queryFieldsSet, BiFunction<Set<String>, List<Index>, Index> matcher) {
        HashSet<Index> indicesUsed = new HashSet<Index>();
        for (QueryFields queryFields : queryFieldsSet) {
            Set<String> qFields = queryFields.getFields();
            Index matchedIndex = matcher.apply(qFields, indices);
            if (matchedIndex == null) {
                return Collections.emptySet();
            }
            indicesUsed.add(matchedIndex);
        }
        return indicesUsed;
    }

    private Index getCoveringIndex(Set<String> qFields, List<Index> indices) {
        for (Index index : indices) {
            List<String> idxFields = index.getFields();
            if (qFields.size() > idxFields.size()) continue;
            boolean matched = true;
            for (int i = 0; i < qFields.size(); ++i) {
                if (qFields.contains(idxFields.get(i))) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return index;
        }
        return null;
    }

    private Index getKeyIndex(Set<String> qFields, List<Index> keyIndices) {
        if (qFields.isEmpty()) {
            return null;
        }
        for (Index index : keyIndices) {
            if (!qFields.containsAll(index.getFields())) continue;
            return index;
        }
        return null;
    }

    Set<QueryFields> getQueryFields(ExprBranches branches) {
        HashSet<QueryFields> queryFieldsSet = new HashSet<QueryFields>();
        branches.forEach(branch -> queryFieldsSet.add(new QueryFields(branch.getFieldNames())));
        return queryFieldsSet;
    }

    Set<QueryFields> getCandidateFieldsForKeyIndex(ExprBranches branches) {
        HashSet<QueryFields> queryFieldsSet = new HashSet<QueryFields>();
        branches.forEach(branch -> {
            HashSet<String> candidates = new HashSet<String>();
            branch.forEach(expr -> {
                if (this.isCandidateFieldForKeyIndex((FieldExprWrapper)expr)) {
                    candidates.add(expr.getFieldName());
                }
            });
            queryFieldsSet.add(new QueryFields(candidates));
        });
        return queryFieldsSet;
    }

    private boolean isCandidateFieldForKeyIndex(FieldExprWrapper wrapper) {
        if (wrapper.isNot()) {
            return false;
        }
        FieldExpr expr = wrapper.getExpr();
        if (expr instanceof MathFieldExpr) {
            return ((MathFieldExpr)expr).getOp() == FQLKeyWord.Operator.EQ;
        }
        return expr instanceof InFieldExpr;
    }

    private IndexPlanner() {
    }
}

