/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.api.framework.expr.util;

import com.envisioniot.enos.api.framework.expr.expressionV2.IExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.ILogicalExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.AndExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.ExistExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.FunctionExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.InExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.IsNullExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.LikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.MathExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.NotExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.OrExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.logical.RLikeExpression;
import com.envisioniot.enos.api.framework.expr.expressionV2.visitor.IExpressionVisitor;
import com.envisioniot.enos.api.framework.expr.util.FieldMapper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FqlFieldNameTranslator
implements IExpressionVisitor<IExpression> {
    private final FieldMapper mapper;

    @Override
    public IExpression visitAndExpression(AndExpression expression) {
        List<ILogicalExpression> expressionList = expression.getExpressionList().stream().map(expr -> (ILogicalExpression)this.visitILogicalExpression((ILogicalExpression)expr)).collect(Collectors.toList());
        expression.setExpressionList(expressionList);
        return expression;
    }

    @Override
    public IExpression visitExistExpression(ExistExpression expression) {
        String mappedName = this.mapper.map(expression.getFieldString());
        if (mappedName != null) {
            ExistExpression existExpression = new ExistExpression();
            existExpression.setField(Arrays.asList(mappedName.split("\\.")));
            return existExpression;
        }
        return expression;
    }

    @Override
    public IExpression visitFunctionExpression(FunctionExpression expression) {
        return expression;
    }

    @Override
    public IExpression visitInExpression(InExpression expression) {
        String mappedField = this.mapper.map(expression.getFieldString());
        if (mappedField != null) {
            InExpression inExpression = new InExpression(expression.getValueList());
            inExpression.setField(Arrays.asList(mappedField.split("\\.")));
            return inExpression;
        }
        return expression;
    }

    @Override
    public IExpression visitIsNullExpression(IsNullExpression expression) {
        String mappedName = this.mapper.map(expression.getFieldString());
        if (mappedName != null) {
            IsNullExpression isNullExpression = new IsNullExpression(expression.isNull());
            isNullExpression.setField(Arrays.asList(mappedName.split("\\.")));
            return isNullExpression;
        }
        return expression;
    }

    @Override
    public IExpression visitLikeExpression(LikeExpression expression) {
        String mappedName = this.mapper.map(expression.getFieldString());
        if (mappedName != null) {
            LikeExpression likeExpression = new LikeExpression(expression.getValue());
            likeExpression.setField(Arrays.asList(mappedName.split("\\.")));
            return likeExpression;
        }
        return expression;
    }

    @Override
    public IExpression visitMathExpression(MathExpression expression) {
        String mappedField = this.mapper.map(expression.getFieldString());
        if (mappedField != null) {
            MathExpression mathExpression = new MathExpression(expression.getOp(), expression.getValue());
            mathExpression.setField(Arrays.asList(mappedField.split("\\.")));
            return mathExpression;
        }
        return expression;
    }

    @Override
    public IExpression visitNotExpression(NotExpression expression) {
        ILogicalExpression expr = (ILogicalExpression)this.visitILogicalExpression(expression.getExpression());
        expression.setExpression(expr);
        return expression;
    }

    @Override
    public IExpression visitOrExpression(OrExpression expression) {
        List<ILogicalExpression> expressionList = expression.getExpressionList().stream().map(expr -> (ILogicalExpression)this.visitILogicalExpression((ILogicalExpression)expr)).collect(Collectors.toList());
        expression.setExpressionList(expressionList);
        return expression;
    }

    @Override
    public IExpression visitRLikeExpression(RLikeExpression expression) {
        String mappedName = this.mapper.map(expression.getFieldString());
        if (mappedName != null) {
            RLikeExpression rLikeExpression = new RLikeExpression(expression.getValue());
            rLikeExpression.setField(Arrays.asList(mappedName.split("\\.")));
            return rLikeExpression;
        }
        return expression;
    }

    public FqlFieldNameTranslator(FieldMapper mapper) {
        this.mapper = mapper;
    }
}

