/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.connect_service.v2_1.ota.firmware;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import com.envisioniot.enos.connect_service.v2_1.ota.firmware.AbstractFirmwareRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class CreateFirmwareFileRequest
extends AbstractFirmwareRequest {
    private String orgId;
    private String productKey;
    private StringI18n name;
    private String version;
    private String signMethod;
    private String desc;
    private Boolean enableVerification;
    private File file;

    public Map<String, Object> queryParams() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("action", this.action());
        if (this.orgId != null) {
            map.put("orgId", this.orgId);
        }
        if (this.productKey != null) {
            map.put("productKey", this.productKey);
        }
        return map;
    }

    public Map<String, Object> formData() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (this.file != null) {
            map.put("file", this.file);
        }
        map.put("metadata", this.buildJsonPayload());
        return map;
    }

    private Map<String, Object> buildJsonPayload() throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>(5);
        if (this.name != null) {
            payload.put("name", this.name);
        }
        if (this.version != null) {
            payload.put("version", this.version);
        }
        if (this.signMethod != null) {
            payload.put("signMethod", this.signMethod);
        }
        if (this.file != null) {
            if ("md5".equalsIgnoreCase(this.signMethod)) {
                payload.put("sign", DigestUtils.md5Hex((InputStream)new FileInputStream(this.file)));
            } else if ("sha256".equalsIgnoreCase(this.signMethod)) {
                payload.put("sign", DigestUtils.sha256Hex((InputStream)new FileInputStream(this.file)));
            }
        }
        if (this.desc != null) {
            payload.put("desc", this.desc);
        }
        if (this.enableVerification != null) {
            payload.put("enableVerification", this.enableVerification);
        }
        return payload;
    }

    @Override
    protected String action() {
        return "create";
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public StringI18n getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public String getDesc() {
        return this.desc;
    }

    public Boolean getEnableVerification() {
        return this.enableVerification;
    }

    public File getFile() {
        return this.file;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public void setName(StringI18n name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setEnableVerification(Boolean enableVerification) {
        this.enableVerification = enableVerification;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        return "CreateFirmwareFileRequest(super=" + super.toString() + ", orgId=" + this.getOrgId() + ", productKey=" + this.getProductKey() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", signMethod=" + this.getSignMethod() + ", desc=" + this.getDesc() + ", enableVerification=" + this.getEnableVerification() + ", file=" + this.getFile() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateFirmwareFileRequest)) {
            return false;
        }
        CreateFirmwareFileRequest other = (CreateFirmwareFileRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$productKey = this.getProductKey();
        String other$productKey = other.getProductKey();
        if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
            return false;
        }
        StringI18n this$name = this.getName();
        StringI18n other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$signMethod = this.getSignMethod();
        String other$signMethod = other.getSignMethod();
        if (this$signMethod == null ? other$signMethod != null : !this$signMethod.equals(other$signMethod)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        Boolean this$enableVerification = this.getEnableVerification();
        Boolean other$enableVerification = other.getEnableVerification();
        if (this$enableVerification == null ? other$enableVerification != null : !((Object)this$enableVerification).equals(other$enableVerification)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateFirmwareFileRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $productKey = this.getProductKey();
        result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
        StringI18n $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $signMethod = this.getSignMethod();
        result = result * 59 + ($signMethod == null ? 43 : $signMethod.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        Boolean $enableVerification = this.getEnableVerification();
        result = result * 59 + ($enableVerification == null ? 43 : ((Object)$enableVerification).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }
}

