/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CompletionListener;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LoadingCacheProxy<K, V>
extends CacheProxy<K, V> {
    final LoadingCache<K, Expirable<V>> cache;

    public LoadingCacheProxy(String name, Executor executor, CacheManager cacheManager, CaffeineConfiguration<K, V> configuration, LoadingCache<K, Expirable<V>> cache, EventDispatcher<K, V> dispatcher, CacheLoader<K, V> cacheLoader, ExpiryPolicy expiry, Ticker ticker, JCacheStatisticsMXBean statistics) {
        super(name, executor, cacheManager, configuration, cache, dispatcher, Optional.of(cacheLoader), expiry, ticker, statistics);
        this.cache = cache;
    }

    @Override
    public @Nullable V get(K key) {
        this.requireNotClosed();
        try {
            V v = this.getOrLoad(key);
            return v;
        }
        catch (ClassCastException | IllegalStateException | NullPointerException | CacheException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.dispatcher.awaitSynchronous();
        }
    }

    private @Nullable V getOrLoad(K key) {
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        long millis = 0L;
        Expirable expirable = (Expirable)this.cache.getIfPresent(key);
        if (expirable != null && !expirable.isEternal() && expirable.hasExpired(millis = LoadingCacheProxy.nanosToMillis(start == 0L ? this.ticker.read() : start))) {
            Expirable expired = expirable;
            this.cache.asMap().computeIfPresent(key, (k, e) -> {
                if (e == expired) {
                    this.dispatcher.publishExpired(this, key, expired.get());
                    this.statistics.recordEvictions(1L);
                    return null;
                }
                return e;
            });
            expirable = null;
        }
        if (expirable == null) {
            expirable = (Expirable)this.cache.get(key);
            this.statistics.recordMisses(1L);
        } else {
            this.statistics.recordHits(1L);
        }
        V value = null;
        if (expirable != null) {
            this.setAccessExpirationTime(key, expirable, millis);
            value = this.copyValue(expirable);
        }
        if (statsEnabled) {
            this.statistics.recordGetTime(this.ticker.read() - start);
        }
        return value;
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll(keys, true);
    }

    private Map<K, V> getAll(Set<? extends K> keys, boolean updateAccessTime) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        try {
            Map entries = this.getAndFilterExpiredEntries(keys, updateAccessTime);
            if (entries.size() != keys.size()) {
                List keysToLoad = keys.stream().filter(key -> !entries.containsKey(key)).collect(Collectors.toList());
                entries.putAll(this.cache.getAll(keysToLoad));
            }
            Map result = this.copyMap(entries);
            if (statsEnabled) {
                this.statistics.recordGetTime(this.ticker.read() - start);
            }
            Map map = result;
            return map;
        }
        catch (ClassCastException | IllegalStateException | NullPointerException | CacheException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.dispatcher.awaitSynchronous();
        }
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.requireNotClosed();
        keys.forEach(Objects::requireNonNull);
        CacheProxy.NullCompletionListener listener = completionListener == null ? CacheProxy.NullCompletionListener.INSTANCE : completionListener;
        this.executor.execute(() -> {
            try {
                if (replaceExistingValues) {
                    int[] ignored = new int[]{0};
                    Map loaded = ((CacheLoader)this.cacheLoader.get()).loadAll((Iterable)keys);
                    for (Map.Entry entry : loaded.entrySet()) {
                        this.putNoCopyOrAwait(entry.getKey(), entry.getValue(), false, ignored);
                    }
                } else {
                    this.getAll(keys, false);
                }
                listener.onCompletion();
            }
            catch (Exception e) {
                listener.onException(e);
            }
            finally {
                this.dispatcher.ignoreSynchronous();
            }
        });
    }
}

