/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.interceptor;

import com.github.lianjiatech.retrofit.spring.boot.core.ErrorDecoder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ErrorDecoderInterceptor
implements Interceptor {
    private final ErrorDecoder errorDecoder;
    private static Map<ErrorDecoder, ErrorDecoderInterceptor> cache = new HashMap<ErrorDecoder, ErrorDecoderInterceptor>(4);

    private ErrorDecoderInterceptor(ErrorDecoder errorDecoder) {
        this.errorDecoder = errorDecoder;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        boolean decoded = false;
        try {
            Response response = chain.proceed(request);
            if (this.errorDecoder == null) {
                return response;
            }
            decoded = true;
            RuntimeException exception = this.errorDecoder.invalidRespDecode(request, response);
            if (exception == null) {
                return response;
            }
            throw exception;
        }
        catch (IOException e) {
            if (decoded) {
                throw e;
            }
            throw this.errorDecoder.ioExceptionDecode(request, e);
        }
        catch (Exception e) {
            if (decoded && e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw this.errorDecoder.exceptionDecode(request, e);
        }
    }

    public static ErrorDecoderInterceptor create(ErrorDecoder errorDecoder) {
        ErrorDecoderInterceptor interceptor = cache.get(errorDecoder);
        if (interceptor != null) {
            return interceptor;
        }
        interceptor = new ErrorDecoderInterceptor(errorDecoder);
        cache.put(errorDecoder, interceptor);
        return interceptor;
    }
}

