/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.annotation.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitFactoryBean;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassPathRetrofitClientScanner
extends ClassPathBeanDefinitionScanner {
    private final ClassLoader classLoader;
    private static final Logger logger = LoggerFactory.getLogger(ClassPathRetrofitClientScanner.class);
    private final Environment environment;

    public ClassPathRetrofitClientScanner(BeanDefinitionRegistry registry, ClassLoader classLoader, Environment environment) {
        super(registry, false);
        this.classLoader = classLoader;
        this.environment = environment;
    }

    public void registerFilters() {
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(RetrofitClient.class);
        this.addIncludeFilter((TypeFilter)annotationTypeFilter);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            logger.warn("No RetrofitClient was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration.");
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        if (beanDefinition.getMetadata().isInterface()) {
            try {
                Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)this.classLoader);
                return !target.isAnnotation() && (this.legalBaseUrl(target) || this.legalServiceId(target));
            }
            catch (Exception ex) {
                logger.error("load class exception:", (Throwable)ex);
            }
        }
        return false;
    }

    private boolean legalBaseUrl(Class<?> target) {
        RetrofitClient retrofitClient = target.getAnnotation(RetrofitClient.class);
        String baseUrl = retrofitClient.baseUrl();
        if (StringUtils.isEmpty((Object)baseUrl)) {
            logger.warn("No config baseUrl! interface={}", target);
            return false;
        }
        try {
            this.environment.resolveRequiredPlaceholders(baseUrl);
        }
        catch (Exception e) {
            logger.warn("No config baseUrl! interface={}", target);
            return false;
        }
        return true;
    }

    private boolean legalServiceId(Class<?> target) {
        RetrofitClient retrofitClient = target.getAnnotation(RetrofitClient.class);
        String serviceId = retrofitClient.serviceId();
        if (StringUtils.isEmpty((Object)serviceId)) {
            logger.warn("No config serviceId! interface={}", target);
            return false;
        }
        try {
            this.environment.resolveRequiredPlaceholders(serviceId);
        }
        catch (Exception e) {
            logger.warn("No config serviceId! interface={}", target);
            return false;
        }
        return true;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating RetrofitClientBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' Interface");
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)Objects.requireNonNull(definition.getBeanClassName()));
            definition.setBeanClass(RetrofitFactoryBean.class);
        }
    }
}

