/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.annotation.RetrofitScan;
import com.github.lianjiatech.retrofit.spring.boot.core.ClassPathRetrofitClientScanner;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class RetrofitClientScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(RetrofitScan.class.getName()));
        if (attributes == null) {
            return;
        }
        ClassPathRetrofitClientScanner scanner = new ClassPathRetrofitClientScanner(registry, this.classLoader, this.environment);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        String[] basePackages = this.getPackagesToScan(attributes);
        scanner.registerFilters();
        scanner.doScan(basePackages);
    }

    private String[] getPackagesToScan(AnnotationAttributes attributes) {
        Object[] value = attributes.getStringArray("value");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        if (!ObjectUtils.isEmpty((Object[])value)) {
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])basePackages), (String)"@RetrofitScan basePackages and value attributes are mutually exclusive");
        }
        LinkedHashSet<Object> packagesToScan = new LinkedHashSet<Object>();
        packagesToScan.addAll(Arrays.asList(value));
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        return packagesToScan.toArray(new String[packagesToScan.size()]);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

