/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.config;

import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.core.SourceOkHttpClientRegistry;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegrade;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ErrorDecoderInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.GlobalInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.NetworkInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ServiceChooseInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.log.LoggingInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryInterceptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import retrofit2.CallAdapter;
import retrofit2.Converter;

public class RetrofitConfigBean {
    private final RetrofitProperties retrofitProperties;
    private List<GlobalInterceptor> globalInterceptors;
    private List<NetworkInterceptor> networkInterceptors;
    private RetryInterceptor retryInterceptor;
    private ServiceChooseInterceptor serviceChooseInterceptor;
    private Class<? extends Converter.Factory>[] globalConverterFactoryClasses;
    private Class<? extends CallAdapter.Factory>[] globalCallAdapterFactoryClasses;
    private RetrofitDegrade retrofitDegrade;
    private LoggingInterceptor loggingInterceptor;
    private ErrorDecoderInterceptor errorDecoderInterceptor;
    private SourceOkHttpClientRegistry sourceOkHttpClientRegistry;

    public RetrofitConfigBean(RetrofitProperties retrofitProperties) {
        this.retrofitProperties = retrofitProperties;
    }

    public List<GlobalInterceptor> getGlobalInterceptors() {
        if (this.globalInterceptors == null) {
            return Collections.emptyList();
        }
        return this.globalInterceptors;
    }

    public List<NetworkInterceptor> getNetworkInterceptors() {
        if (this.networkInterceptors == null) {
            return Collections.emptyList();
        }
        return this.networkInterceptors;
    }

    public RetrofitProperties getRetrofitProperties() {
        return this.retrofitProperties;
    }

    public RetryInterceptor getRetryInterceptor() {
        return this.retryInterceptor;
    }

    public ServiceChooseInterceptor getServiceChooseInterceptor() {
        return this.serviceChooseInterceptor;
    }

    public Class<? extends Converter.Factory>[] getGlobalConverterFactoryClasses() {
        return this.globalConverterFactoryClasses;
    }

    public Class<? extends CallAdapter.Factory>[] getGlobalCallAdapterFactoryClasses() {
        return this.globalCallAdapterFactoryClasses;
    }

    public RetrofitDegrade getRetrofitDegrade() {
        return this.retrofitDegrade;
    }

    public LoggingInterceptor getLoggingInterceptor() {
        return this.loggingInterceptor;
    }

    public ErrorDecoderInterceptor getErrorDecoderInterceptor() {
        return this.errorDecoderInterceptor;
    }

    public SourceOkHttpClientRegistry getSourceOkHttpClientRegistry() {
        return this.sourceOkHttpClientRegistry;
    }

    public void setGlobalInterceptors(List<GlobalInterceptor> globalInterceptors) {
        this.globalInterceptors = globalInterceptors;
    }

    public void setNetworkInterceptors(List<NetworkInterceptor> networkInterceptors) {
        this.networkInterceptors = networkInterceptors;
    }

    public void setRetryInterceptor(RetryInterceptor retryInterceptor) {
        this.retryInterceptor = retryInterceptor;
    }

    public void setServiceChooseInterceptor(ServiceChooseInterceptor serviceChooseInterceptor) {
        this.serviceChooseInterceptor = serviceChooseInterceptor;
    }

    public void setGlobalConverterFactoryClasses(Class<? extends Converter.Factory>[] globalConverterFactoryClasses) {
        this.globalConverterFactoryClasses = globalConverterFactoryClasses;
    }

    public void setGlobalCallAdapterFactoryClasses(Class<? extends CallAdapter.Factory>[] globalCallAdapterFactoryClasses) {
        this.globalCallAdapterFactoryClasses = globalCallAdapterFactoryClasses;
    }

    public void setRetrofitDegrade(RetrofitDegrade retrofitDegrade) {
        this.retrofitDegrade = retrofitDegrade;
    }

    public void setLoggingInterceptor(LoggingInterceptor loggingInterceptor) {
        this.loggingInterceptor = loggingInterceptor;
    }

    public void setErrorDecoderInterceptor(ErrorDecoderInterceptor errorDecoderInterceptor) {
        this.errorDecoderInterceptor = errorDecoderInterceptor;
    }

    public void setSourceOkHttpClientRegistry(SourceOkHttpClientRegistry sourceOkHttpClientRegistry) {
        this.sourceOkHttpClientRegistry = sourceOkHttpClientRegistry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetrofitConfigBean)) {
            return false;
        }
        RetrofitConfigBean other = (RetrofitConfigBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RetrofitProperties this$retrofitProperties = this.getRetrofitProperties();
        RetrofitProperties other$retrofitProperties = other.getRetrofitProperties();
        if (this$retrofitProperties == null ? other$retrofitProperties != null : !((Object)this$retrofitProperties).equals(other$retrofitProperties)) {
            return false;
        }
        List<GlobalInterceptor> this$globalInterceptors = this.getGlobalInterceptors();
        List<GlobalInterceptor> other$globalInterceptors = other.getGlobalInterceptors();
        if (this$globalInterceptors == null ? other$globalInterceptors != null : !((Object)this$globalInterceptors).equals(other$globalInterceptors)) {
            return false;
        }
        List<NetworkInterceptor> this$networkInterceptors = this.getNetworkInterceptors();
        List<NetworkInterceptor> other$networkInterceptors = other.getNetworkInterceptors();
        if (this$networkInterceptors == null ? other$networkInterceptors != null : !((Object)this$networkInterceptors).equals(other$networkInterceptors)) {
            return false;
        }
        RetryInterceptor this$retryInterceptor = this.getRetryInterceptor();
        RetryInterceptor other$retryInterceptor = other.getRetryInterceptor();
        if (this$retryInterceptor == null ? other$retryInterceptor != null : !this$retryInterceptor.equals(other$retryInterceptor)) {
            return false;
        }
        ServiceChooseInterceptor this$serviceChooseInterceptor = this.getServiceChooseInterceptor();
        ServiceChooseInterceptor other$serviceChooseInterceptor = other.getServiceChooseInterceptor();
        if (this$serviceChooseInterceptor == null ? other$serviceChooseInterceptor != null : !this$serviceChooseInterceptor.equals(other$serviceChooseInterceptor)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGlobalConverterFactoryClasses(), other.getGlobalConverterFactoryClasses())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGlobalCallAdapterFactoryClasses(), other.getGlobalCallAdapterFactoryClasses())) {
            return false;
        }
        RetrofitDegrade this$retrofitDegrade = this.getRetrofitDegrade();
        RetrofitDegrade other$retrofitDegrade = other.getRetrofitDegrade();
        if (this$retrofitDegrade == null ? other$retrofitDegrade != null : !this$retrofitDegrade.equals(other$retrofitDegrade)) {
            return false;
        }
        LoggingInterceptor this$loggingInterceptor = this.getLoggingInterceptor();
        LoggingInterceptor other$loggingInterceptor = other.getLoggingInterceptor();
        if (this$loggingInterceptor == null ? other$loggingInterceptor != null : !this$loggingInterceptor.equals(other$loggingInterceptor)) {
            return false;
        }
        ErrorDecoderInterceptor this$errorDecoderInterceptor = this.getErrorDecoderInterceptor();
        ErrorDecoderInterceptor other$errorDecoderInterceptor = other.getErrorDecoderInterceptor();
        if (this$errorDecoderInterceptor == null ? other$errorDecoderInterceptor != null : !this$errorDecoderInterceptor.equals(other$errorDecoderInterceptor)) {
            return false;
        }
        SourceOkHttpClientRegistry this$sourceOkHttpClientRegistry = this.getSourceOkHttpClientRegistry();
        SourceOkHttpClientRegistry other$sourceOkHttpClientRegistry = other.getSourceOkHttpClientRegistry();
        return !(this$sourceOkHttpClientRegistry == null ? other$sourceOkHttpClientRegistry != null : !this$sourceOkHttpClientRegistry.equals(other$sourceOkHttpClientRegistry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetrofitConfigBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RetrofitProperties $retrofitProperties = this.getRetrofitProperties();
        result = result * 59 + ($retrofitProperties == null ? 43 : ((Object)$retrofitProperties).hashCode());
        List<GlobalInterceptor> $globalInterceptors = this.getGlobalInterceptors();
        result = result * 59 + ($globalInterceptors == null ? 43 : ((Object)$globalInterceptors).hashCode());
        List<NetworkInterceptor> $networkInterceptors = this.getNetworkInterceptors();
        result = result * 59 + ($networkInterceptors == null ? 43 : ((Object)$networkInterceptors).hashCode());
        RetryInterceptor $retryInterceptor = this.getRetryInterceptor();
        result = result * 59 + ($retryInterceptor == null ? 43 : $retryInterceptor.hashCode());
        ServiceChooseInterceptor $serviceChooseInterceptor = this.getServiceChooseInterceptor();
        result = result * 59 + ($serviceChooseInterceptor == null ? 43 : $serviceChooseInterceptor.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getGlobalConverterFactoryClasses());
        result = result * 59 + Arrays.deepHashCode(this.getGlobalCallAdapterFactoryClasses());
        RetrofitDegrade $retrofitDegrade = this.getRetrofitDegrade();
        result = result * 59 + ($retrofitDegrade == null ? 43 : $retrofitDegrade.hashCode());
        LoggingInterceptor $loggingInterceptor = this.getLoggingInterceptor();
        result = result * 59 + ($loggingInterceptor == null ? 43 : $loggingInterceptor.hashCode());
        ErrorDecoderInterceptor $errorDecoderInterceptor = this.getErrorDecoderInterceptor();
        result = result * 59 + ($errorDecoderInterceptor == null ? 43 : $errorDecoderInterceptor.hashCode());
        SourceOkHttpClientRegistry $sourceOkHttpClientRegistry = this.getSourceOkHttpClientRegistry();
        result = result * 59 + ($sourceOkHttpClientRegistry == null ? 43 : $sourceOkHttpClientRegistry.hashCode());
        return result;
    }

    public String toString() {
        return "RetrofitConfigBean(retrofitProperties=" + this.getRetrofitProperties() + ", globalInterceptors=" + this.getGlobalInterceptors() + ", networkInterceptors=" + this.getNetworkInterceptors() + ", retryInterceptor=" + this.getRetryInterceptor() + ", serviceChooseInterceptor=" + this.getServiceChooseInterceptor() + ", globalConverterFactoryClasses=" + Arrays.deepToString(this.getGlobalConverterFactoryClasses()) + ", globalCallAdapterFactoryClasses=" + Arrays.deepToString(this.getGlobalCallAdapterFactoryClasses()) + ", retrofitDegrade=" + this.getRetrofitDegrade() + ", loggingInterceptor=" + this.getLoggingInterceptor() + ", errorDecoderInterceptor=" + this.getErrorDecoderInterceptor() + ", sourceOkHttpClientRegistry=" + this.getSourceOkHttpClientRegistry() + ")";
    }
}

