/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.core.BodyCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.ResponseCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitClient;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.MonoCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava2CompletableCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava2SingleCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava3CompletableCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.core.reactive.Rxjava3SingleCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeProxy;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegrade;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.Intercept;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.InterceptMark;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.Intercepts;
import com.github.lianjiatech.retrofit.spring.boot.util.AppContextUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.BeanExtendUtils;
import com.github.lianjiatech.retrofit.spring.boot.util.RetrofitUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

public class RetrofitFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationContextAware {
    private final Class<T> retrofitInterface;
    private Environment environment;
    private RetrofitConfigBean retrofitConfigBean;
    private ApplicationContext applicationContext;

    public RetrofitFactoryBean(Class<T> retrofitInterface) {
        this.retrofitInterface = retrofitInterface;
    }

    public T getObject() throws Exception {
        Object source = this.createRetrofit().create(this.retrofitInterface);
        if (!this.isEnableDegrade(this.retrofitInterface)) {
            return (T)source;
        }
        this.retrofitConfigBean.getRetrofitDegrade().loadDegradeRules(this.retrofitInterface);
        return DegradeProxy.create(source, this.retrofitInterface, this.applicationContext);
    }

    public boolean isEnableDegrade(Class<?> retrofitInterface) {
        RetrofitDegrade retrofitDegrade = this.retrofitConfigBean.getRetrofitDegrade();
        if (retrofitDegrade == null) {
            return false;
        }
        return retrofitDegrade.isEnableDegrade(retrofitInterface);
    }

    public Class<T> getObjectType() {
        return this.retrofitInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private OkHttpClient createOkHttpClient() {
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation(this.retrofitInterface, RetrofitClient.class);
        OkHttpClient sourceOkHttpClient = this.retrofitConfigBean.getSourceOkHttpClientRegistry().get(Objects.requireNonNull(retrofitClient).sourceOkHttpClient());
        OkHttpClient.Builder okHttpClientBuilder = sourceOkHttpClient.newBuilder();
        if (this.isEnableDegrade(this.retrofitInterface)) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getRetrofitDegrade());
        }
        if (StringUtils.hasText((String)retrofitClient.serviceId())) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getServiceChooseInterceptor());
        }
        okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getErrorDecoderInterceptor());
        this.findInterceptorByAnnotation().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        this.retrofitConfigBean.getGlobalInterceptors().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getRetryInterceptor());
        okHttpClientBuilder.addInterceptor((Interceptor)this.retrofitConfigBean.getLoggingInterceptor());
        this.retrofitConfigBean.getNetworkInterceptors().forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        return okHttpClientBuilder.build();
    }

    private List<Interceptor> findInterceptorByAnnotation() {
        Annotation[] classAnnotations = AnnotationUtils.getAnnotations(this.retrofitInterface);
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        ArrayList<Annotation> interceptAnnotations = new ArrayList<Annotation>();
        for (Annotation classAnnotation : Objects.requireNonNull(classAnnotations)) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptMark.class)) {
                interceptAnnotations.add(classAnnotation);
            }
            if (!(classAnnotation instanceof Intercepts)) continue;
            Intercept[] value2 = ((Intercepts)classAnnotation).value();
            interceptAnnotations.addAll(Arrays.asList(value2));
        }
        for (Annotation interceptAnnotation : interceptAnnotations) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)interceptAnnotation);
            Object handler = annotationAttributes.get("handler");
            Assert.notNull(handler, (String)"@InterceptMark annotations must be configured: Class<? extends BasePathMatchInterceptor> handler()");
            Assert.notNull(annotationAttributes.get("include"), (String)"@InterceptMark annotations must be configured: String[] include()");
            Assert.notNull(annotationAttributes.get("exclude"), (String)"@InterceptMark annotations must be configured: String[] exclude()");
            Class interceptorClass = (Class)handler;
            BasePathMatchInterceptor interceptor = (BasePathMatchInterceptor)AppContextUtils.getTargetInstanceIfNecessary(AppContextUtils.getBeanOrNew(this.applicationContext, interceptorClass));
            HashMap annotationResolveAttributes = new HashMap(8);
            annotationAttributes.forEach((key, value) -> {
                if (value instanceof String) {
                    String newValue = this.environment.resolvePlaceholders((String)value);
                    annotationResolveAttributes.put(key, newValue);
                } else {
                    annotationResolveAttributes.put(key, value);
                }
            });
            BeanExtendUtils.populate(interceptor, annotationResolveAttributes);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private Retrofit createRetrofit() {
        RetrofitClient retrofitClient = (RetrofitClient)AnnotatedElementUtils.findMergedAnnotation(this.retrofitInterface, RetrofitClient.class);
        String baseUrl = RetrofitUtils.convertBaseUrl(retrofitClient, retrofitClient.baseUrl(), this.environment);
        OkHttpClient client = this.createOkHttpClient();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).validateEagerly(retrofitClient.validateEagerly()).client(client);
        this.combineAndCreate(retrofitClient.callAdapterFactories(), this.retrofitConfigBean.getGlobalCallAdapterFactoryClasses()).forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addCallAdapterFactory(arg_0));
        this.addReactiveCallAdapterFactory(retrofitBuilder);
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)ResponseCallAdapterFactory.INSTANCE);
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)BodyCallAdapterFactory.INSTANCE);
        this.combineAndCreate(retrofitClient.converterFactories(), this.retrofitConfigBean.getGlobalConverterFactoryClasses()).forEach(arg_0 -> ((Retrofit.Builder)retrofitBuilder).addConverterFactory(arg_0));
        return retrofitBuilder.build();
    }

    private void addReactiveCallAdapterFactory(Retrofit.Builder retrofitBuilder) {
        if (this.reactor3ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)MonoCallAdapterFactory.INSTANCE);
        }
        if (this.rxjava2ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava2SingleCallAdapterFactory.INSTANCE);
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava2CompletableCallAdapterFactory.INSTANCE);
        }
        if (this.rxjava3ClassExist()) {
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava3SingleCallAdapterFactory.INSTANCE);
            retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)Rxjava3CompletableCallAdapterFactory.INSTANCE);
        }
    }

    private boolean rxjava3ClassExist() {
        try {
            Class.forName("io.reactivex.rxjava3.core.Single");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean rxjava2ClassExist() {
        try {
            Class.forName("io.reactivex.Single");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean reactor3ClassExist() {
        try {
            Class.forName("reactor.core.publisher.Mono");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private <E> List<E> combineAndCreate(Class<? extends E>[] clz, Class<? extends E>[] globalClz) {
        if (clz.length == 0 && globalClz.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends E>> combineClz = new ArrayList<Class<? extends E>>(clz.length + globalClz.length);
        combineClz.addAll(Arrays.asList(clz));
        combineClz.addAll(Arrays.asList(globalClz));
        ArrayList result = new ArrayList(combineClz.size());
        for (Class clazz : combineClz) {
            result.add(AppContextUtils.getBeanOrNew(this.applicationContext, clazz));
        }
        return result;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.retrofitConfigBean = (RetrofitConfigBean)applicationContext.getBean(RetrofitConfigBean.class);
    }
}

