/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GsubLookupType3
extends OpenTableLookup {
    private Map<Integer, int[]> substMap = new HashMap<Integer, int[]>();

    public GsubLookupType3(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        int[] substCode;
        if (line.idx >= line.end) {
            return false;
        }
        Glyph g = line.get(line.idx);
        boolean changed = false;
        if (!this.openReader.isSkip(g.getCode(), this.lookupFlag) && (substCode = this.substMap.get(g.getCode())) != null && substCode[0] != g.getCode()) {
            line.substituteOneToOne(this.openReader, substCode[0]);
            changed = true;
        }
        ++line.idx;
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        short substFormat = this.openReader.rf.readShort();
        assert (substFormat == 1);
        int coverage = this.openReader.rf.readUnsignedShort();
        int alternateSetCount = this.openReader.rf.readUnsignedShort();
        int[][] substitute = new int[alternateSetCount][];
        int[] alternateLocations = this.openReader.readUShortArray(alternateSetCount, subTableLocation);
        for (int k = 0; k < alternateSetCount; ++k) {
            this.openReader.rf.seek(alternateLocations[k]);
            int glyphCount = this.openReader.rf.readUnsignedShort();
            substitute[k] = this.openReader.readUShortArray(glyphCount);
        }
        List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverage);
        for (int k = 0; k < alternateSetCount; ++k) {
            this.substMap.put(coverageGlyphIds.get(k), substitute[k]);
        }
    }

    @Override
    public boolean hasSubstitution(int index) {
        return this.substMap.containsKey(index);
    }
}

