/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractStatementWrapper;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.rs.RestfulConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class SchemalessStatement
extends AbstractStatementWrapper {
    public SchemalessStatement(Statement statement) {
        super(statement);
    }

    public void executeSchemaless(String[] strings, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        Connection connection = this.getConnection();
        if (!(connection instanceof TSDBConnection)) {
            if (connection instanceof RestfulConnection) {
                throw TSDBError.createSQLException(8962, "restful connection is not supported currently");
            }
            throw TSDBError.createSQLException(9040, "unknown connection\uff1a" + connection.getMetaData().getURL());
        }
        TSDBConnection tsdbConnection = (TSDBConnection)connection;
        tsdbConnection.getConnector().insertLines(strings, protocolType, timestampType);
    }

    public void executeSchemaless(String sql, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.executeSchemaless(new String[]{sql}, protocolType, timestampType);
    }
}

