/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.config.ChatGPTUrl;
import com.unfbx.chatgpt.entity.common.Choice;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.entity.completions.CompletionResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPTClient {
    private static final Logger log = LoggerFactory.getLogger(ChatGPTClient.class);
    private String apiKey;

    public ChatGPTClient(String apiKey) {
        this.apiKey = apiKey;
    }

    @Deprecated
    public String askQuestion(String question) {
        Completion q = Completion.builder().prompt(question).build();
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.post((String)ChatGPTUrl.COMPLETIONS.getUrl()).body(JSONUtil.toJsonStr((Object)q)).header(Header.AUTHORIZATION.getValue(), "Bearer " + this.apiKey)).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue())).execute();
        String body = response.body();
        log.info("\u8c03\u7528ChatGPT\u8bf7\u6c42\u8fd4\u56de\u503c\uff1a{}", (Object)body);
        if (!response.isOk()) {
            if (response.getStatus() == 401) {
                CompletionResponse answer = (CompletionResponse)JSONUtil.toBean((String)response.body(), CompletionResponse.class);
                throw new BaseException(answer.getError().getMessage());
            }
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        log.info("\u8c03\u7528ChatGPT\u8bf7\u6c42\u8fd4\u56de\u503c\uff1a{}", (Object)body);
        CompletionResponse answer = (CompletionResponse)JSONUtil.toBean((String)body, CompletionResponse.class);
        if (Objects.nonNull(answer.getError())) {
            return answer.getError().getMessage();
        }
        List<Choice> choiceList = Arrays.stream(answer.getChoices()).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(choiceList)) {
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        StringBuilder msg = new StringBuilder();
        choiceList.forEach(e -> {
            msg.append(e.getText());
            msg.append("\n");
        });
        return msg.toString();
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

