/*
 * Decompiled with CFR 0.152.
 */
package com.mg.swagger.framework.filter;

import com.mg.swagger.framework.service.MgStorageService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MgUiTestFilter
implements Filter {
    @Autowired(required=false)
    private MgStorageService mgStorageService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String mockTestFlag = request.getParameter("mgUiTestFlag");
        if (!"1".equals(mockTestFlag)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestUrl = httpServletRequest.getRequestURI();
        String cacheResult = this.mgStorageService.get("p-simulation-response-" + requestUrl);
        if (cacheResult != null) {
            MgUiTestFilter.responseWrite(cacheResult, (HttpServletResponse)response);
        }
    }

    public void destroy() {
    }

    private static void responseWrite(String params, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.getWriter().write(params);
    }
}

