/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.EntityResolver;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import de.pdark.decentxml.dtd.DocTypeAttributeList;
import de.pdark.decentxml.dtd.DocTypeElement;
import de.pdark.decentxml.dtd.DocTypeEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocType
extends BasicNode {
    private String name;
    private DocTypeType docTypeType = DocTypeType.INLINE;
    private String publicLiteral;
    private String systemLiteral;
    private String notationDataName;
    private List<Node> nodes = new ArrayList<Node>();
    private Map<String, DocTypeElement> nameToElement = new HashMap<String, DocTypeElement>();
    private Map<String, List<DocTypeAttributeList>> nameToAttributeList = new HashMap<String, List<DocTypeAttributeList>>();
    private Map<String, DocTypeEntity> parameterEntities = new HashMap<String, DocTypeEntity>();
    private Map<String, DocTypeEntity> entities = new HashMap<String, DocTypeEntity>();

    public DocType(Token token) {
        super(token);
    }

    public DocType() {
        super(XMLTokenizer.Type.DOCTYPE, "<!DOCTYPE");
    }

    public void add(Node n) {
        this.nodes.add(n);
        if (n.getType() == XMLTokenizer.Type.DOCTYPE_ELEMENT) {
            DocTypeElement e = (DocTypeElement)n;
            this.nameToElement.put(e.getName(), e);
        } else if (n.getType() == XMLTokenizer.Type.DOCTYPE_ATTLIST) {
            DocTypeAttributeList alist = (DocTypeAttributeList)n;
            String key = alist.getElementName();
            List<DocTypeAttributeList> definitions = this.nameToAttributeList.get(key);
            if (definitions == null) {
                definitions = new ArrayList<DocTypeAttributeList>();
                this.nameToAttributeList.put(key, definitions);
            }
            definitions.add(alist);
        } else if (n.getType() == XMLTokenizer.Type.DOCTYPE_ENTITY) {
            DocTypeEntity entity = (DocTypeEntity)n;
            if (entity.isParameterEntity()) {
                if (!this.parameterEntities.containsKey(entity.getName())) {
                    this.parameterEntities.put(entity.getName(), entity);
                }
            } else if (!this.entities.containsKey(entity.getName())) {
                this.entities.put(entity.getName(), entity);
            }
        }
    }

    public void mapElementsAndAttributes() {
        for (Map.Entry<String, List<DocTypeAttributeList>> entry : this.nameToAttributeList.entrySet()) {
            String elementName = entry.getKey();
            DocTypeElement element = this.getElement(elementName);
            if (element == null) continue;
            element.setAttLists(entry.getValue());
            for (DocTypeAttributeList attList : entry.getValue()) {
                attList.setElement(element);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocTypeType getDocTypeType() {
        return this.docTypeType;
    }

    public void setDocTypeType(DocTypeType docTypeType) {
        this.docTypeType = docTypeType;
    }

    public String getPublicLiteral() {
        return this.publicLiteral;
    }

    public void setPublicLiteral(String publicLiteral) {
        this.publicLiteral = publicLiteral;
    }

    public String getSystemLiteral() {
        return this.systemLiteral;
    }

    public void setSystemLiteral(String systemLiteral) {
        this.systemLiteral = systemLiteral;
    }

    public String getNotationDataName() {
        return this.notationDataName;
    }

    public void setNotationDataName(String notationDataName) {
        this.notationDataName = notationDataName;
    }

    @Override
    public DocType toXML(XMLWriter writer) throws IOException {
        super.toXML(writer);
        for (Node n : this.nodes) {
            n.toXML(writer);
        }
        return this;
    }

    public DocTypeElement getElement(String name) {
        return this.nameToElement.get(name.trim());
    }

    public List<DocTypeElement> getElements() {
        return new ArrayList<DocTypeElement>(this.nameToElement.values());
    }

    public List<DocTypeAttributeList> getAttributeList(String name) {
        return this.nameToAttributeList.get(name);
    }

    public List<List<DocTypeAttributeList>> getAttributeLists() {
        return new ArrayList<List<DocTypeAttributeList>>(this.nameToAttributeList.values());
    }

    public DocTypeEntity getEntity(String name) {
        return this.entities.get(name);
    }

    public EntityResolver getEntityResolver() {
        return this.getEntityResolver(null);
    }

    public EntityResolver getEntityResolver(EntityResolver parent) {
        EntityResolver resolver = new EntityResolver(parent);
        for (DocTypeEntity e : this.entities.values()) {
            resolver.add(e.getName(), e.getText());
        }
        return resolver;
    }

    public DocTypeEntity getParameterEntity(String name) {
        return this.parameterEntities.get(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocTypeType {
        INLINE,
        SYSTEM,
        PUBLIC;

    }
}

