/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.EofMessage;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.message.server.WarningMessage;
import io.netty.buffer.ByteBuf;

final class Eof41Message
implements EofMessage,
WarningMessage,
ServerStatusMessage {
    static final int SIZE = 5;
    private final int warnings;
    private final short serverStatuses;

    private Eof41Message(int warnings, short serverStatuses) {
        this.warnings = warnings;
        this.serverStatuses = serverStatuses;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isDone() {
        return (this.serverStatuses & 8) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Eof41Message)) {
            return false;
        }
        Eof41Message that = (Eof41Message)o;
        if (this.warnings != that.warnings) {
            return false;
        }
        return this.serverStatuses == that.serverStatuses;
    }

    public int hashCode() {
        int result = this.warnings;
        result = 31 * result + this.serverStatuses;
        return result;
    }

    public String toString() {
        if (this.warnings != 0) {
            return String.format("Eof41Message{warnings=%d, serverStatuses=%x}", this.warnings, this.serverStatuses);
        }
        return String.format("Eof41Message{serverStatuses=%x}", this.serverStatuses);
    }

    static Eof41Message decode(ByteBuf buf) {
        buf.skipBytes(1);
        int warnings = buf.readUnsignedShortLE();
        return new Eof41Message(warnings, buf.readShortLE());
    }
}

