/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.reactor.bulkhead.operator.FluxBulkhead;
import io.github.resilience4j.reactor.bulkhead.operator.MonoBulkhead;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BulkheadOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final Bulkhead bulkhead;

    private BulkheadOperator(Bulkhead bulkhead) {
        this.bulkhead = bulkhead;
    }

    public static <T> BulkheadOperator<T> of(Bulkhead bulkhead) {
        return new BulkheadOperator<T>(bulkhead);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoBulkhead((Mono)publisher, this.bulkhead);
        }
        if (publisher instanceof Flux) {
            return new FluxBulkhead((Flux)publisher, this.bulkhead);
        }
        throw new IllegalPublisherException(publisher);
    }
}

