/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class SignalFxNamingConvention
implements NamingConvention {
    private static final Pattern START_UNDERSCORE_PATTERN = Pattern.compile("^_");
    private static final Pattern SF_PATTERN = Pattern.compile("^sf_");
    private static final Pattern START_LETTERS_PATTERN = Pattern.compile("^[a-zA-Z].*");
    private static final int NAME_MAX_LENGTH = 256;
    private static final int TAG_VALUE_MAX_LENGTH = 256;
    private static final int KEY_MAX_LENGTH = 128;
    private final NamingConvention delegate;

    public SignalFxNamingConvention() {
        this(NamingConvention.dot);
    }

    public SignalFxNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String formattedName = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit));
        return StringUtils.truncate((String)formattedName, (int)256);
    }

    public String tagKey(String key) {
        String conventionKey = this.delegate.tagKey(key);
        conventionKey = START_UNDERSCORE_PATTERN.matcher(conventionKey).replaceAll("");
        if (!START_LETTERS_PATTERN.matcher(conventionKey = SF_PATTERN.matcher(conventionKey).replaceAll("")).matches()) {
            conventionKey = "a" + conventionKey;
        }
        return StringUtils.truncate((String)conventionKey, (int)128);
    }

    public String tagValue(String value) {
        String formattedValue = StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
        return StringUtils.truncate((String)formattedValue, (int)256);
    }
}

