/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.retry.Jitter;
import reactor.retry.Retry;
import reactor.retry.RetryContext;
import reactor.retry.RetryExtensionsKt$sam$Consumer$9b1d389c;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a`\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u001c\b\u0002\u0010\n\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u001a`\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u001c\b\u0002\u0010\n\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u001aV\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u001c\b\u0002\u0010\n\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u001aV\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u001c\b\u0002\u0010\n\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a8\u0006\u0010"}, d2={"retryExponentialBackoff", "Lreactor/core/publisher/Flux;", "T", "times", "", "first", "Ljava/time/Duration;", "max", "jitter", "", "doOnRetry", "Lkotlin/Function1;", "Lreactor/retry/RetryContext;", "", "Lreactor/core/publisher/Mono;", "retryRandomBackoff", "reactor-extra"})
public final class RetryExtensionsKt {
    @NotNull
    public static final <T> Flux<T> retryExponentialBackoff(@NotNull Flux<T> $receiver, long times, @NotNull Duration first, @Nullable Duration max, boolean jitter, @Nullable Function1<? super RetryContext<T>, Unit> doOnRetry) {
        Flux flux;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Retry retry = Retry.any().retryMax(times).exponentialBackoff(first, max).jitter(jitter ? Jitter.random() : Jitter.noJitter());
        if (doOnRetry == null) {
            Flux flux2 = retry.apply((Publisher)$receiver);
            flux = flux2;
            Intrinsics.checkExpressionValueIsNotNull(flux2, (String)"retry.apply(this)");
        } else {
            Function1<? super RetryContext<T>, Unit> function1 = doOnRetry;
            Flux flux3 = retry.doOnRetry(new RetryExtensionsKt$sam$Consumer$9b1d389c(function1)).apply((Publisher)$receiver);
            flux = flux3;
            Intrinsics.checkExpressionValueIsNotNull(flux3, (String)"retry.doOnRetry(doOnRetry).apply(this)");
        }
        return flux;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Flux retryExponentialBackoff$default(Flux flux, long l, Duration duration, Duration duration2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            duration2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        return RetryExtensionsKt.retryExponentialBackoff(flux, l, duration, duration2, bl, function1);
    }

    @NotNull
    public static final <T> Flux<T> retryRandomBackoff(@NotNull Flux<T> $receiver, long times, @NotNull Duration first, @Nullable Duration max, @Nullable Function1<? super RetryContext<T>, Unit> doOnRetry) {
        Flux flux;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Retry retry = Retry.any().retryMax(times).randomBackoff(first, max);
        if (doOnRetry == null) {
            Flux flux2 = retry.apply((Publisher)$receiver);
            flux = flux2;
            Intrinsics.checkExpressionValueIsNotNull(flux2, (String)"retry.apply(this)");
        } else {
            Function1<? super RetryContext<T>, Unit> function1 = doOnRetry;
            Flux flux3 = retry.doOnRetry(new RetryExtensionsKt$sam$Consumer$9b1d389c(function1)).apply((Publisher)$receiver);
            flux = flux3;
            Intrinsics.checkExpressionValueIsNotNull(flux3, (String)"retry.doOnRetry(doOnRetry).apply(this)");
        }
        return flux;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Flux retryRandomBackoff$default(Flux flux, long l, Duration duration, Duration duration2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            duration2 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return RetryExtensionsKt.retryRandomBackoff(flux, l, duration, duration2, function1);
    }

    @NotNull
    public static final <T> Mono<T> retryExponentialBackoff(@NotNull Mono<T> $receiver, long times, @NotNull Duration first, @Nullable Duration max, boolean jitter, @Nullable Function1<? super RetryContext<T>, Unit> doOnRetry) {
        Mono mono;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Retry retry = Retry.any().retryMax(times).exponentialBackoff(first, max).jitter(jitter ? Jitter.random() : Jitter.noJitter());
        if (doOnRetry == null) {
            Mono mono2 = $receiver.retryWhen((Function)retry);
            mono = mono2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"this.retryWhen(retry)");
        } else {
            Function1<? super RetryContext<T>, Unit> function1 = doOnRetry;
            Mono mono3 = $receiver.retryWhen((Function)retry.doOnRetry(new RetryExtensionsKt$sam$Consumer$9b1d389c(function1)));
            mono = mono3;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono3, (String)"this.retryWhen(retry.doOnRetry(doOnRetry))");
        }
        return mono;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Mono retryExponentialBackoff$default(Mono mono, long l, Duration duration, Duration duration2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            duration2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        return RetryExtensionsKt.retryExponentialBackoff(mono, l, duration, duration2, bl, function1);
    }

    @NotNull
    public static final <T> Mono<T> retryRandomBackoff(@NotNull Mono<T> $receiver, long times, @NotNull Duration first, @Nullable Duration max, @Nullable Function1<? super RetryContext<T>, Unit> doOnRetry) {
        Mono mono;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Retry retry = Retry.any().retryMax(times).randomBackoff(first, max);
        if (doOnRetry == null) {
            Mono mono2 = $receiver.retryWhen((Function)retry);
            mono = mono2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"this.retryWhen(retry)");
        } else {
            Function1<? super RetryContext<T>, Unit> function1 = doOnRetry;
            Mono mono3 = $receiver.retryWhen((Function)retry.doOnRetry(new RetryExtensionsKt$sam$Consumer$9b1d389c(function1)));
            mono = mono3;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono3, (String)"this.retryWhen(retry.doOnRetry(doOnRetry))");
        }
        return mono;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Mono retryRandomBackoff$default(Mono mono, long l, Duration duration, Duration duration2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            duration2 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return RetryExtensionsKt.retryRandomBackoff(mono, l, duration, duration2, function1);
    }
}

