/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.ProtoModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CompilerUtil {
    public static Writer newWriter(ProtoModule module, String packageName, String fileName) throws IOException {
        File packageDir;
        String encoding = module.getEncoding();
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        if (!(packageDir = new File(module.getOutputDir(), packageName.replace('.', '/'))).exists()) {
            packageDir.mkdirs();
        }
        File outputFile = new File(packageDir, fileName);
        FileOutputStream out = new FileOutputStream(outputFile);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
    }

    public static List<File> getProtoFiles(File dir) {
        return CompilerUtil.getFilesByExtension(dir, new String[]{".proto"});
    }

    public static List<File> getFilesByExtension(File dir, String[] extensions) {
        if (!dir.isDirectory() || extensions == null) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        CompilerUtil.addFilesByExtension(files, dir, extensions);
        return files;
    }

    static void addFilesByExtension(List<File> list, File dir, String[] extensions) {
        File[] files = dir.listFiles();
        block0: for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                CompilerUtil.addFilesByExtension(list, f, extensions);
                continue;
            }
            for (String s : extensions) {
                if (!f.getName().endsWith(s)) continue;
                list.add(f);
                continue block0;
            }
        }
    }
}

