/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.FilenameUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.DefaultProtoLoader;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoUtil;
import io.protostuff.parser.Service;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class PluginProtoCompiler
extends STCodeGenerator {
    protected static final boolean CHECK_FILENAME_PLACEHOLDER = Boolean.getBoolean("ppc.check_filename_placeholder");
    public static final GroupResolver GROUP_RESOLVER;
    private static GroupResolver __resolver;
    public final ProtoModule module;
    public final StringTemplateGroup group;
    public final StringTemplate enumBlockTemplate;
    public final StringTemplate messageBlockTemplate;
    public final StringTemplate protoBlockTemplate;
    public final StringTemplate serviceBlockTemplate;
    public final boolean javaOutput;
    public final String fileExtension;
    public final String outputName;
    public final String outputPrefix;
    public final String outputSuffix;

    public static void setGroupResolver(GroupResolver resolver) {
        if (resolver != null) {
            __resolver = resolver;
        }
    }

    public static StringTemplate getTemplateFrom(StringTemplateGroup group, String template) {
        try {
            return group.lookupTemplate(template);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public PluginProtoCompiler(ProtoModule module, String stgLocation) {
        this(module, stgLocation, CHECK_FILENAME_PLACEHOLDER);
    }

    public PluginProtoCompiler(ProtoModule module, String stgLocation, boolean checkFilenamePlaceHolder) {
        this(module, checkFilenamePlaceHolder, PluginProtoCompiler.resolveSTG(stgLocation));
    }

    public PluginProtoCompiler(ProtoModule module, boolean checkFilenamePlaceHolder, StringTemplateGroup group) {
        super(module.getOutput());
        int placeHolder;
        this.module = module;
        this.group = group;
        this.protoBlockTemplate = PluginProtoCompiler.getTemplateFrom(group, "proto_block");
        if (this.protoBlockTemplate == null) {
            this.enumBlockTemplate = PluginProtoCompiler.getTemplateFrom(group, "enum_block");
            this.messageBlockTemplate = PluginProtoCompiler.getTemplateFrom(group, "message_block");
            this.serviceBlockTemplate = PluginProtoCompiler.getTemplateFrom(group, "service_block");
            if (this.enumBlockTemplate == null && this.messageBlockTemplate == null && this.serviceBlockTemplate == null) {
                throw new IllegalStateException("At least one of these templates (proto_block|service_block|message_block|enum_block) need to be declared in " + module.getOutput());
            }
        } else {
            this.enumBlockTemplate = null;
            this.messageBlockTemplate = null;
            this.serviceBlockTemplate = null;
        }
        this.fileExtension = PluginProtoCompiler.getFileExtension(module.getOutput());
        this.javaOutput = ".java".equalsIgnoreCase(this.fileExtension);
        this.outputName = PluginProtoCompiler.getOutputName(module.getOutput());
        int n = placeHolder = checkFilenamePlaceHolder ? this.outputName.indexOf(36) : -1;
        if (placeHolder == -1) {
            this.outputPrefix = "";
            this.outputSuffix = "";
        } else if (placeHolder == 0) {
            this.outputPrefix = "";
            this.outputSuffix = this.outputName.length() == 1 ? "" : this.outputName.substring(1);
        } else if (placeHolder == this.outputName.length() - 1) {
            this.outputPrefix = this.outputName.substring(0, this.outputName.length() - 1);
            this.outputSuffix = "";
        } else {
            this.outputPrefix = this.outputName.substring(0, placeHolder);
            this.outputSuffix = this.outputName.substring(placeHolder + 1);
        }
    }

    static String getOutputName(String resource) {
        String filename = FilenameUtil.getFileName(resource);
        int secondToTheLastDot = filename.lastIndexOf(46, filename.length() - 5);
        return filename.substring(0, secondToTheLastDot);
    }

    public static String getFileExtension(String resource) {
        int secondToTheLastDot = resource.lastIndexOf(46, resource.length() - 5);
        if (secondToTheLastDot == -1) {
            throw new IllegalArgumentException("The resource must be named like: 'foo.type.stg' where '.type' will be the file extension of the output files.");
        }
        String extension = resource.substring(secondToTheLastDot, resource.length() - 4);
        if (extension.length() < 2) {
            throw new IllegalArgumentException("The resource must be named like: 'foo.type.stg' where '.type' will be the file extension of the output files.");
        }
        return extension;
    }

    public static StringTemplateGroup resolveSTG(String stgLocation) {
        return __resolver.resolveSTG(stgLocation);
    }

    public String resolveFileName(String name) {
        return this.outputPrefix + name + this.outputSuffix + this.fileExtension;
    }

    @Override
    public void compile(ProtoModule module, Proto proto) throws IOException {
        String packageName;
        if (!this.module.getOutput().startsWith(module.getOutput())) {
            throw new IllegalArgumentException("Wrong module: " + this.module.getOutput() + " != " + module.getOutput());
        }
        String string = packageName = this.javaOutput ? proto.getJavaPackageName() : proto.getPackageName();
        if (this.protoBlockTemplate != null) {
            this.compileProtoBlock(module, proto, packageName, this.protoBlockTemplate);
            return;
        }
        if (this.serviceBlockTemplate != null) {
            for (Service service : proto.getServices()) {
                this.compileServiceBlock(module, service, packageName, this.resolveFileName(service.getName()), this.serviceBlockTemplate);
            }
        }
        if (this.enumBlockTemplate != null) {
            for (EnumGroup eg : proto.getEnumGroups()) {
                PluginProtoCompiler.compileEnumBlock(module, eg, packageName, this.resolveFileName(eg.getName()), this.enumBlockTemplate);
            }
        }
        if (this.messageBlockTemplate != null) {
            for (Message message : proto.getMessages()) {
                PluginProtoCompiler.compileMessageBlock(module, message, packageName, this.resolveFileName(message.getName()), this.messageBlockTemplate);
            }
        }
    }

    private void compileServiceBlock(ProtoModule module, Service service, String packageName, String fileName, StringTemplate serviceBlockTemplate) throws IOException {
        Writer writer = CompilerUtil.newWriter(module, packageName, fileName);
        PluginProtoCompiler.compileServiceBlockTo(writer, module, service, serviceBlockTemplate);
        writer.close();
    }

    public static void compileServiceBlockTo(Writer writer, ProtoModule module, Service service, StringTemplate serviceBlockTemplate) throws IOException {
        AutoIndentWriter out = new AutoIndentWriter(writer);
        StringTemplate messageBlock = serviceBlockTemplate.getInstanceOf();
        messageBlock.setAttribute("service", (Object)service);
        messageBlock.setAttribute("module", (Object)module);
        messageBlock.setAttribute("options", (Object)module.getOptions());
        messageBlock.write((StringTemplateWriter)out);
    }

    public static void compileEnumBlock(ProtoModule module, EnumGroup eg, String packageName, String fileName, StringTemplate enumBlockTemplate) throws IOException {
        Writer writer = CompilerUtil.newWriter(module, packageName, fileName);
        PluginProtoCompiler.compileEnumBlockTo(writer, module, eg, enumBlockTemplate);
        writer.close();
    }

    public static void compileEnumBlockTo(Writer writer, ProtoModule module, EnumGroup eg, StringTemplate enumBlockTemplate) throws IOException {
        AutoIndentWriter out = new AutoIndentWriter(writer);
        StringTemplate enumBlock = enumBlockTemplate.getInstanceOf();
        enumBlock.setAttribute("eg", (Object)eg);
        enumBlock.setAttribute("module", (Object)module);
        enumBlock.setAttribute("options", (Object)module.getOptions());
        enumBlock.write((StringTemplateWriter)out);
    }

    public static void compileMessageBlock(ProtoModule module, Message message, String packageName, String fileName, StringTemplate messageBlockTemplate) throws IOException {
        Writer writer = CompilerUtil.newWriter(module, packageName, fileName);
        PluginProtoCompiler.compileMessageBlockTo(writer, module, message, messageBlockTemplate);
        writer.close();
    }

    public static void compileMessageBlockTo(Writer writer, ProtoModule module, Message message, StringTemplate messageBlockTemplate) throws IOException {
        AutoIndentWriter out = new AutoIndentWriter(writer);
        StringTemplate messageBlock = messageBlockTemplate.getInstanceOf();
        messageBlock.setAttribute("message", (Object)message);
        messageBlock.setAttribute("module", (Object)module);
        messageBlock.setAttribute("options", (Object)module.getOptions());
        messageBlock.write((StringTemplateWriter)out);
    }

    public void compileProtoBlock(ProtoModule module, Proto proto, String packageName, StringTemplate protoBlockTemplate) throws IOException {
        String fileName;
        String outerClassname;
        String name = ProtoUtil.toPascalCase((String)proto.getFile().getName().replace(".proto", "")).toString();
        if (this.javaOutput && (outerClassname = (String)proto.getExtraOption("java_outer_classname")) != null) {
            name = outerClassname;
        }
        if (this.outputPrefix.isEmpty() && this.outputSuffix.isEmpty()) {
            String outerFileSuffix;
            String outerFilePrefix = module.getOption("outer_file_prefix");
            if (outerFilePrefix != null) {
                name = outerFilePrefix + name;
            }
            if ((outerFileSuffix = module.getOption("outer_file_suffix")) != null) {
                name = name + outerFileSuffix;
            }
            fileName = name + this.fileExtension;
        } else {
            fileName = this.resolveFileName(name);
        }
        Writer writer = CompilerUtil.newWriter(module, packageName, fileName);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        StringTemplate protoBlock = protoBlockTemplate.getInstanceOf();
        protoBlock.setAttribute("proto", (Object)proto);
        protoBlock.setAttribute("module", (Object)module);
        protoBlock.setAttribute("options", (Object)module.getOptions());
        protoBlock.write((StringTemplateWriter)out);
        writer.close();
    }

    static {
        __resolver = GROUP_RESOLVER = new GroupResolver(){

            @Override
            public StringTemplateGroup resolveSTG(String stgLocation) {
                try {
                    File file = new File(stgLocation);
                    if (file.exists()) {
                        return new StringTemplateGroup((Reader)new BufferedReader(new FileReader(file)));
                    }
                    URL url = DefaultProtoLoader.getResource((String)stgLocation, PluginProtoCompiler.class);
                    if (url != null) {
                        return new StringTemplateGroup((Reader)new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8")));
                    }
                    if (stgLocation.startsWith("http://")) {
                        return new StringTemplateGroup((Reader)new BufferedReader(new InputStreamReader(new URL(stgLocation).openStream(), "UTF-8")));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw new IllegalStateException("Could not find " + stgLocation);
            }
        };
    }

    public static interface GroupResolver {
        public StringTemplateGroup resolveSTG(String var1);
    }
}

