/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.io.IOException;
import java.io.Writer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class ProtoToJavaBeanCompiler
extends STCodeGenerator {
    public ProtoToJavaBeanCompiler() {
        this("java_bean");
    }

    public ProtoToJavaBeanCompiler(String id) {
        super(id);
    }

    @Override
    public void compile(ProtoModule module, Proto proto) throws IOException {
        String javaPackageName = proto.getJavaPackageName();
        String template = module.getOption("separate_schema") == null ? "java_bean" : "java_bean_separate_schema";
        StringTemplateGroup group = ProtoToJavaBeanCompiler.getSTG(template);
        this.writeEnums(module, proto, javaPackageName, group);
        this.writeMessages(module, proto, javaPackageName, group);
    }

    protected void writeMessages(ProtoModule module, Proto proto, String javaPackageName, StringTemplateGroup group) throws IOException {
        for (Message m : proto.getMessages()) {
            Writer writer = CompilerUtil.newWriter(module, javaPackageName, m.getName() + ".java");
            AutoIndentWriter out = new AutoIndentWriter(writer);
            StringTemplate messageBlock = group.getInstanceOf("message_block");
            messageBlock.setAttribute("message", (Object)m);
            messageBlock.setAttribute("module", (Object)module);
            messageBlock.setAttribute("options", (Object)module.getOptions());
            messageBlock.write((StringTemplateWriter)out);
            writer.close();
        }
    }

    protected void writeEnums(ProtoModule module, Proto proto, String javaPackageName, StringTemplateGroup group) throws IOException {
        for (EnumGroup eg : proto.getEnumGroups()) {
            Writer writer = CompilerUtil.newWriter(module, javaPackageName, eg.getName() + ".java");
            AutoIndentWriter out = new AutoIndentWriter(writer);
            StringTemplate enumBlock = group.getInstanceOf("enum_block");
            enumBlock.setAttribute("eg", (Object)eg);
            enumBlock.setAttribute("module", (Object)module);
            enumBlock.setAttribute("options", (Object)module.getOptions());
            enumBlock.write((StringTemplateWriter)out);
            writer.close();
        }
    }
}

