/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.CharacterEncoder;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.codec.StringCodec;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Clob;
import java.util.EnumSet;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ClobCodec
extends AbstractCodec<Clob> {
    public static final ClobCodec INSTANCE = new ClobCodec();
    private static final Set<SqlServerType> SUPPORTED_TYPES = EnumSet.of(SqlServerType.CHAR, new SqlServerType[]{SqlServerType.NCHAR, SqlServerType.VARCHAR, SqlServerType.NVARCHAR, SqlServerType.VARCHARMAX, SqlServerType.NVARCHARMAX, SqlServerType.TEXT, SqlServerType.NTEXT});

    private ClobCodec() {
        super(Clob.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Clob value) {
        return CharacterEncoder.encodePlp(allocator, context.getRequiredValueContext(RpcParameterContext.CharacterValueContext.class), value);
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return StringCodec.INSTANCE.doEncodeNull(allocator);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return SUPPORTED_TYPES.contains((Object)typeInformation.getServerType());
    }

    @Override
    @Nullable
    public Clob decode(@Nullable ByteBuf buffer, Decodable decodable, Class<? extends Clob> type) {
        Length length;
        Assert.requireNonNull(decodable, "Decodable must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        if (buffer == null) {
            return null;
        }
        if (decodable.getType().getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            PlpLength plpLength = PlpLength.decode(buffer, decodable.getType());
            length = Length.of(Math.toIntExact(plpLength.getLength()), plpLength.isNull());
        } else {
            length = Length.decode(buffer, decodable.getType());
        }
        if (length.isNull()) {
            return null;
        }
        return this.doDecode(buffer, length, decodable.getType(), type);
    }

    @Override
    Clob doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends Clob> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            int startIndex = buffer.readerIndex();
            while (buffer.isReadable()) {
                Length chunkLength = Length.decode(buffer, type);
                buffer.skipBytes(chunkLength.getLength());
            }
            int endIndex = buffer.readerIndex();
            buffer.readerIndex(startIndex);
            return new ScalarClob(type, length, buffer.readRetainedSlice(endIndex - startIndex));
        }
        return new ScalarClob(type, length, buffer.readRetainedSlice(length.getLength()));
    }

    static class ScalarClob
    implements Clob {
        final TypeInformation type;
        private final Length valueLength;
        final ByteBuf buffer;

        ScalarClob(TypeInformation type, Length valueLength, ByteBuf buffer) {
            this.type = type;
            this.valueLength = valueLength;
            this.buffer = buffer.touch((Object)"ScalarClob");
        }

        public Publisher<CharSequence> stream() {
            return Flux.generate(sink -> {
                try {
                    if (!this.buffer.isReadable()) {
                        sink.complete();
                        return;
                    }
                    Length length = this.type.getLengthStrategy() == LengthStrategy.PARTLENTYPE ? Length.decode(this.buffer, this.type) : this.valueLength;
                    String value = this.buffer.toString(this.buffer.readerIndex(), length.getLength(), this.type.getCharset());
                    this.buffer.skipBytes(length.getLength());
                    sink.next((Object)value);
                }
                catch (Exception e) {
                    sink.error((Throwable)e);
                }
            }).doOnCancel(() -> {
                if (this.buffer.refCnt() > 0) {
                    this.buffer.release();
                }
            }).doAfterTerminate(() -> {
                if (this.buffer.refCnt() > 0) {
                    this.buffer.release();
                }
            });
        }

        public Publisher<Void> discard() {
            return Mono.fromRunnable(() -> {
                if (this.buffer.refCnt() > 0) {
                    this.buffer.release();
                }
            });
        }
    }
}

