/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

final class LocalDateCodec
extends AbstractCodec<LocalDate> {
    public static final LocalDateCodec INSTANCE = new LocalDateCodec();
    private static final LocalDate DATE_ZERO = LocalDate.of(1, 1, 1);
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeTemporalNull(alloc, SqlServerType.DATE));

    private LocalDateCodec() {
        super(LocalDate.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, LocalDate value) {
        ByteBuf buffer = allocator.buffer(4);
        buffer.writeByte(3);
        LocalDateCodec.encode(buffer, value);
        return new RpcEncoding.HintedEncoded(TdsDataType.DATEN, SqlServerType.DATE, buffer);
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.DATE);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.DATE;
    }

    @Override
    LocalDate doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends LocalDate> valueType) {
        if (length.isNull()) {
            return null;
        }
        int days = buffer.readByte() & 0xFF | (buffer.readByte() & 0xFF) << 8 | (buffer.readByte() & 0xFF) << 16;
        return DATE_ZERO.plusDays(days);
    }

    static void encode(ByteBuf buffer, LocalDate value) {
        long days = ChronoUnit.DAYS.between(DATE_ZERO, value);
        buffer.writeByte((byte)days & 0xFF);
        buffer.writeByte((byte)(days >> 8) & 0xFF);
        buffer.writeByte((byte)(days >> 16) & 0xFF);
    }
}

