/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ColumnSource;
import io.r2dbc.mssql.MssqlColumnMetadata;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

final class MssqlRowMetadata
extends ColumnSource
implements RowMetadata,
Collection<String> {
    private final Codecs codecs;
    @Nullable
    private Map<Column, MssqlColumnMetadata> metadataCache;

    MssqlRowMetadata(Codecs codecs, Column[] columns, Map<String, Column> nameKeyedColumns) {
        super(columns, nameKeyedColumns);
        this.codecs = Assert.requireNonNull(codecs, "Codecs must not be null");
    }

    public static MssqlRowMetadata create(Codecs codecs, ColumnMetadataToken columnMetadata) {
        Assert.notNull((Object)columnMetadata, "ColumnMetadata must not be null");
        return new MssqlRowMetadata(codecs, columnMetadata.getColumns(), columnMetadata.toMap());
    }

    public MssqlColumnMetadata getColumnMetadata(int index) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent(this.getColumn(index), column -> new MssqlColumnMetadata((Column)column, this.codecs));
    }

    public MssqlColumnMetadata getColumnMetadata(String identifier) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent(this.getColumn(identifier), column -> new MssqlColumnMetadata((Column)column, this.codecs));
    }

    public List<MssqlColumnMetadata> getColumnMetadatas() {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        ArrayList<MssqlColumnMetadata> metadatas = new ArrayList<MssqlColumnMetadata>(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            MssqlColumnMetadata columnMetadata = this.metadataCache.computeIfAbsent(this.getColumn(i), column -> new MssqlColumnMetadata((Column)column, this.codecs));
            metadatas.add(columnMetadata);
        }
        return metadatas;
    }

    public Collection<String> getColumnNames() {
        return this;
    }

    @Override
    public int size() {
        return this.getColumnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.findColumn((String)o) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        final Column[] columns = this.getColumns();
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return columns.length > this.index;
            }

            @Override
            public String next() {
                Column column = columns[this.index++];
                return column.getName();
            }
        };
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getColumn(i).getName();
        }
        return result;
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

