/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.r2dbc.mssql.client.EnvironmentChangeEvent;
import io.r2dbc.mssql.client.EnvironmentChangeListener;
import io.r2dbc.mssql.message.header.Header;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.PacketIdProvider;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.tds.ContextualTdsFragment;
import io.r2dbc.mssql.message.tds.FirstTdsFragment;
import io.r2dbc.mssql.message.tds.LastTdsFragment;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.message.tds.TdsPacket;
import io.r2dbc.mssql.message.token.EnvChangeToken;
import io.r2dbc.mssql.util.Assert;

public final class TdsEncoder
extends ChannelOutboundHandlerAdapter
implements EnvironmentChangeListener {
    public static final int INITIAL_PACKET_SIZE = 8000;
    private CompositeByteBuf lastChunkRemainder;
    private final PacketIdProvider packetIdProvider;
    private int packetSize;
    private HeaderOptions headerOptions;

    public TdsEncoder(PacketIdProvider packetIdProvider) {
        this(packetIdProvider, 8000);
    }

    public TdsEncoder(PacketIdProvider packetIdProvider, int packetSize) {
        this.packetIdProvider = Assert.requireNonNull(packetIdProvider, "PacketId Provider must not be null");
        this.packetSize = packetSize;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg == ResetHeader.INSTANCE) {
            this.headerOptions = null;
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            return;
        }
        if (msg instanceof HeaderOptions) {
            this.headerOptions = (HeaderOptions)msg;
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            return;
        }
        if (msg instanceof ByteBuf) {
            if (this.headerOptions == null) {
                ctx.write(msg, promise);
                return;
            }
            ByteBuf message = (ByteBuf)msg;
            if (message.readableBytes() <= 0) {
                ctx.write(msg, promise);
                return;
            }
            this.doWriteFragment(ctx, promise, message, this.headerOptions, true);
            return;
        }
        if (msg instanceof TdsPacket) {
            TdsPacket packet = (TdsPacket)msg;
            ByteBuf message = packet.encode(ctx.alloc(), this.packetIdProvider);
            Assert.state(message.readableBytes() <= this.packetSize, "Packet size exceeded");
            ctx.write((Object)message, promise);
            return;
        }
        if (msg instanceof FirstTdsFragment) {
            FirstTdsFragment fragment = (FirstTdsFragment)msg;
            this.headerOptions = fragment.getHeaderOptions();
            this.doWriteFragment(ctx, promise, fragment.getByteBuf(), this.headerOptions, false);
            return;
        }
        if (msg instanceof ContextualTdsFragment) {
            ContextualTdsFragment fragment = (ContextualTdsFragment)msg;
            this.doWriteFragment(ctx, promise, fragment.getByteBuf(), fragment.getHeaderOptions(), true);
            return;
        }
        if (msg instanceof LastTdsFragment) {
            Assert.state(this.headerOptions != null, "HeaderOptions must not be null!");
            TdsFragment fragment = (TdsFragment)msg;
            this.doWriteFragment(ctx, promise, fragment.getByteBuf(), this.headerOptions, true);
            this.headerOptions = null;
            return;
        }
        if (msg instanceof TdsFragment) {
            Assert.state(this.headerOptions != null, "HeaderOptions must not be null!");
            TdsFragment fragment = (TdsFragment)msg;
            this.doWriteFragment(ctx, promise, fragment.getByteBuf(), this.headerOptions, false);
            return;
        }
        throw new IllegalArgumentException(String.format("Unsupported message type: %s", msg));
    }

    @Override
    public void onEnvironmentChange(EnvironmentChangeEvent event) {
        EnvChangeToken token = event.getToken();
        if (token.getChangeType() == EnvChangeToken.EnvChangeType.Packetsize) {
            this.setPacketSize(Integer.parseInt(token.getNewValueString()));
        }
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    private static HeaderOptions getLastHeader(HeaderOptions headerOptions) {
        return headerOptions.and(Status.StatusBit.EOM);
    }

    private static HeaderOptions getChunkedHeaderOptions(HeaderOptions headerOptions) {
        return headerOptions.not(Status.StatusBit.EOM);
    }

    private void doWriteFragment(ChannelHandlerContext ctx, ChannelPromise promise, ByteBuf body, HeaderOptions headerOptions, boolean lastLogicalPacket) {
        if (this.requiresChunking(body.readableBytes())) {
            this.writeChunkedMessage(ctx, promise, body, headerOptions, lastLogicalPacket);
        } else {
            this.writeSingleMessage(ctx, promise, body, headerOptions, lastLogicalPacket);
        }
        body.release();
    }

    private void writeSingleMessage(ChannelHandlerContext ctx, ChannelPromise promise, ByteBuf body, HeaderOptions headerOptions, boolean lastLogicalPacket) {
        if (lastLogicalPacket || this.getBytesToWrite(body.readableBytes()) == this.getPacketSize()) {
            HeaderOptions optionsToUse = lastLogicalPacket ? TdsEncoder.getLastHeader(headerOptions) : headerOptions;
            int messageLength = this.getBytesToWrite(body.readableBytes());
            ByteBuf buffer = ctx.alloc().buffer(messageLength);
            Header.encode(buffer, optionsToUse, messageLength, this.packetIdProvider);
            if (this.lastChunkRemainder != null) {
                buffer.writeBytes((ByteBuf)this.lastChunkRemainder);
                this.lastChunkRemainder.release();
                this.lastChunkRemainder = null;
            }
            buffer.writeBytes(body);
            ctx.write((Object)buffer, promise);
        } else {
            if (this.lastChunkRemainder == null) {
                this.lastChunkRemainder = body.alloc().compositeBuffer();
            }
            this.lastChunkRemainder.addComponent(true, body.retain());
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
        }
    }

    private void writeChunkedMessage(ChannelHandlerContext ctx, ChannelPromise promise, ByteBuf body, HeaderOptions headerOptions, boolean lastLogicalPacket) {
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        try {
            while (body.readableBytes() > 0) {
                ByteBuf chunk = body.alloc().buffer(this.estimateChunkSize(this.getBytesToWrite(body.readableBytes())));
                if (this.lastChunkRemainder != null) {
                    int combinedSize = this.lastChunkRemainder.readableBytes() + body.readableBytes();
                    HeaderOptions optionsToUse = this.isLastTransportPacket(combinedSize, lastLogicalPacket) ? TdsEncoder.getLastHeader(headerOptions) : TdsEncoder.getChunkedHeaderOptions(headerOptions);
                    Header.encode(chunk, optionsToUse, this.packetSize, this.packetIdProvider);
                    int actualBodyReadableBytes = this.packetSize - 8 - this.lastChunkRemainder.readableBytes();
                    chunk.writeBytes((ByteBuf)this.lastChunkRemainder);
                    chunk.writeBytes(body, actualBodyReadableBytes);
                    this.lastChunkRemainder.release();
                    this.lastChunkRemainder = null;
                } else {
                    if (!lastLogicalPacket && !this.requiresChunking(body.readableBytes())) {
                        this.lastChunkRemainder = body.alloc().compositeBuffer();
                        this.lastChunkRemainder.addComponent(true, body.retain());
                        break;
                    }
                    HeaderOptions optionsToUse = this.isLastTransportPacket(body.readableBytes(), lastLogicalPacket) ? TdsEncoder.getLastHeader(headerOptions) : TdsEncoder.getChunkedHeaderOptions(headerOptions);
                    int byteCount = this.getEffectiveChunkSizeWithoutHeader(body.readableBytes());
                    Header.encode(chunk, optionsToUse, 8 + byteCount, this.packetIdProvider);
                    chunk.writeBytes(body, byteCount);
                }
                combiner.add((Future)ctx.write((Object)chunk, ctx.newPromise()));
            }
            combiner.finish((Promise)promise);
        }
        catch (RuntimeException e) {
            promise.tryFailure((Throwable)e);
            throw e;
        }
    }

    int estimateChunkSize(int readableBytes) {
        return Math.min(readableBytes + 8, this.packetSize);
    }

    private boolean requiresChunking(int readableBytes) {
        return this.getBytesToWrite(readableBytes) > this.packetSize;
    }

    private int getBytesToWrite(int readableBytes) {
        int bytesToWrite = 8;
        bytesToWrite += this.lastChunkRemainder != null ? this.lastChunkRemainder.readableBytes() : 0;
        return bytesToWrite += readableBytes;
    }

    private int getEffectiveChunkSizeWithoutHeader(int readableBytes) {
        return Math.min(readableBytes, this.packetSize - 8);
    }

    private boolean isLastTransportPacket(int readableBytes, boolean lastLogicalPacket) {
        if (this.requiresChunking(readableBytes)) {
            return false;
        }
        return lastLogicalPacket;
    }

    public static enum ResetHeader {
        INSTANCE;

    }
}

