/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.DataToken;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

public class ReturnValue
extends AbstractReferenceCounted
implements DataToken {
    public static final byte TYPE = -84;
    private final int ordinal;
    @Nullable
    private final String parameterName;
    private final byte status;
    private final TypeInformation type;
    private final ByteBuf value;

    public ReturnValue(int ordinal, @Nullable String parameterName, byte status, TypeInformation type, ByteBuf value) {
        this.ordinal = ordinal;
        this.parameterName = parameterName;
        this.status = status;
        this.type = type;
        this.value = value;
    }

    public static ReturnValue decode(ByteBuf buffer, boolean encryptionSupported) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        int ordinal = Decode.uShort(buffer);
        String name = Decode.unicodeBString(buffer);
        byte status = Decode.asByte(buffer);
        TypeInformation type = TypeInformation.decode(buffer, true);
        int beforeLengthDescriptor = buffer.readerIndex();
        Length length = Length.decode(buffer, type);
        int descriptorLength = buffer.readerIndex() - beforeLengthDescriptor;
        buffer.readerIndex(beforeLengthDescriptor);
        ByteBuf value = buffer.readRetainedSlice(descriptorLength + length.getLength());
        return new ReturnValue(ordinal, name, status, type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, boolean encryptionSupported) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        int readerIndex = buffer.readerIndex();
        try {
            int requiredLength = 3;
            if (buffer.readableBytes() >= requiredLength) {
                buffer.skipBytes(2);
                byte nameLength = Decode.asByte(buffer);
                if (buffer.readableBytes() < nameLength + 1) {
                    boolean bl = false;
                    return bl;
                }
                buffer.skipBytes(nameLength + 1);
                if (!TypeInformation.canDecode(buffer, true)) {
                    boolean bl = false;
                    return bl;
                }
                TypeInformation type = TypeInformation.decode(buffer, true);
                if (!Length.canDecode(buffer, type)) {
                    boolean bl = false;
                    return bl;
                }
                Length length = Length.decode(buffer, type);
                if (buffer.readableBytes() >= length.getLength()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
        return false;
    }

    public static boolean matches(Message message, String name) {
        Assert.requireNonNull(message, "Message must not be null");
        Assert.requireNonNull(name, "Name must not be null");
        return message instanceof ReturnValue && name.equals(((ReturnValue)message).getParameterName());
    }

    public static boolean matches(Message message, int ordinal) {
        Assert.requireNonNull(message, "Message must not be null");
        return message instanceof ReturnValue && ordinal == ((ReturnValue)message).getOrdinal();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Nullable
    public String getParameterName() {
        return this.parameterName;
    }

    public TypeInformation getValueType() {
        return this.type;
    }

    public byte getStatus() {
        return this.status;
    }

    public ByteBuf getValue() {
        return this.value;
    }

    public Decodable asDecodable() {
        return new Decodable(){

            @Override
            public TypeInformation getType() {
                return ReturnValue.this.getValueType();
            }

            @Override
            public String getName() {
                return ReturnValue.this.getParameterName() == null ? "" : ReturnValue.this.getParameterName();
            }
        };
    }

    @Override
    public byte getType() {
        return -84;
    }

    @Override
    public String getName() {
        return "RETURNVALUE";
    }

    public ReferenceCounted touch(Object hint) {
        this.value.touch(hint);
        return this;
    }

    protected void deallocate() {
        this.value.release();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [ordinal=").append(this.ordinal);
        sb.append(", parameterName='").append(this.parameterName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append(", type=").append(this.type);
        sb.append(']');
        return sb.toString();
    }
}

