/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.util.Assert;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

final class GeneratedValues {
    private static final String GENERATED_KEYS_QUERY = "SELECT SCOPE_IDENTITY() AS ";
    private static final String DEFAULT_GENERATED_KEY_NAME = "GENERATED_KEYS";

    GeneratedValues() {
    }

    static Flux<Message> reduceToSingleCountDoneToken(Flux<? extends Message> messages) {
        return Flux.defer(() -> {
            AtomicReference countToken = new AtomicReference();
            AtomicBoolean rerouteCountFrame = new AtomicBoolean(true);
            return messages.handle((message, sink) -> {
                if (rerouteCountFrame.get() && AbstractDoneToken.hasCount(message)) {
                    if (countToken.get() == null) {
                        countToken.set((AbstractDoneToken)message);
                        return;
                    }
                    if (countToken.get() != null) {
                        rerouteCountFrame.set(false);
                        sink.next(countToken.get());
                        return;
                    }
                }
                sink.next(message);
            });
        });
    }

    static String augmentQuery(String sql, @Nullable String[] generatedColumns) {
        if (GeneratedValues.shouldExpectGeneratedKeys(generatedColumns)) {
            return sql + " " + GeneratedValues.getGeneratedKeysClause(generatedColumns);
        }
        return sql;
    }

    static boolean shouldExpectGeneratedKeys(@Nullable String[] generatedColumns) {
        return generatedColumns != null;
    }

    static String getGeneratedKeysClause(String ... columns) {
        Assert.requireNonNull(columns, "Columns must not be null");
        if (columns.length == 0) {
            return "SELECT SCOPE_IDENTITY() AS GENERATED_KEYS";
        }
        if (columns.length == 1) {
            Assert.requireNonNull(columns[0], "Column must not be null");
            return GENERATED_KEYS_QUERY + columns[0];
        }
        throw new UnsupportedOperationException("SQL Server does not support multiple generated keys");
    }
}

