/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.LoginConfiguration;
import io.r2dbc.mssql.LoginFlow;
import io.r2dbc.mssql.MssqlConnection;
import io.r2dbc.mssql.MssqlConnectionConfiguration;
import io.r2dbc.mssql.MssqlConnectionFactoryMetadata;
import io.r2dbc.mssql.MssqlConnectionMetadata;
import io.r2dbc.mssql.SimpleMssqlStatement;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.client.ClientConfiguration;
import io.r2dbc.mssql.client.ReactorNettyClient;
import io.r2dbc.mssql.message.tds.Redirect;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.Row;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MssqlConnectionFactory
implements ConnectionFactory {
    private final String METADATA_QUERY = " SELECT CAST(SERVERPROPERTY('Edition') AS VARCHAR(255)) AS Edition, CAST(@@VERSION AS VARCHAR(255)) as VersionString";
    private final Function<MssqlConnectionConfiguration, Mono<Client>> clientFactory;
    private final MssqlConnectionConfiguration configuration;
    private final ConnectionOptions connectionOptions;

    public MssqlConnectionFactory(MssqlConnectionConfiguration configuration) {
        this(MssqlConnectionFactory::connect, configuration);
    }

    MssqlConnectionFactory(Function<MssqlConnectionConfiguration, Mono<Client>> clientFactory, MssqlConnectionConfiguration configuration) {
        this.clientFactory = Assert.requireNonNull(clientFactory, "clientFactory must not be null");
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
        this.connectionOptions = configuration.toConnectionOptions();
    }

    private static Mono<Client> connect(MssqlConnectionConfiguration configuration) {
        return Mono.defer(() -> {
            Assert.requireNonNull(configuration, "configuration must not be null");
            return ReactorNettyClient.connect(configuration.toClientConfiguration(), configuration.getApplicationName(), configuration.getConnectionId());
        });
    }

    private Mono<Client> initializeClient(MssqlConnectionConfiguration configuration, boolean allowReroute) {
        LoginConfiguration loginConfiguration = configuration.getLoginConfiguration();
        return this.clientFactory.apply(configuration).delayUntil(client -> LoginFlow.exchange(client, loginConfiguration).onErrorResume(e -> this.propagateError(client.close(), (Throwable)e))).flatMap(client -> client.getRedirect().map(redirect -> {
            if (allowReroute) {
                return this.redirectClient((Client)client, (Redirect)redirect);
            }
            return this.propagateError(client.close(), (Throwable)((Object)new MssqlRoutingException("Client was redirected more than once")));
        }).orElse(Mono.just((Object)client)));
    }

    private Mono<Client> redirectClient(Client client, Redirect redirect) {
        MssqlConnectionConfiguration routeConfiguration = this.configuration.withRedirect(redirect);
        return client.close().then(this.initializeClient(routeConfiguration, false));
    }

    private <T> Mono<T> propagateError(Mono<?> action, Throwable e) {
        return action.onErrorResume(suppressed -> {
            e.addSuppressed((Throwable)suppressed);
            return Mono.error((Throwable)e);
        }).then(Mono.error((Throwable)e));
    }

    public Mono<MssqlConnection> create() {
        return this.initializeClient(this.configuration, true).flatMap(it -> {
            Flux connectionFlux = new SimpleMssqlStatement((Client)it, this.connectionOptions, " SELECT CAST(SERVERPROPERTY('Edition') AS VARCHAR(255)) AS Edition, CAST(@@VERSION AS VARCHAR(255)) as VersionString").execute().flatMap(result -> result.map((row, rowMetadata) -> MssqlConnectionFactory.toConnectionMetadata(it.getDatabaseVersion().orElse("unknown"), row))).map(metadata -> new MssqlConnection((Client)it, (MssqlConnectionMetadata)metadata, this.connectionOptions));
            return connectionFlux.last().onErrorResume(throwable -> it.close().then(Mono.error((Throwable)new R2dbcNonTransientResourceException("Cannot connect to " + this.configuration.getHost() + ":" + this.configuration.getPort(), throwable))));
        });
    }

    private static MssqlConnectionMetadata toConnectionMetadata(String version, Row row) {
        return MssqlConnectionMetadata.from((String)row.get("Edition", String.class), version, (String)row.get("VersionString", String.class));
    }

    ClientConfiguration getClientConfiguration() {
        return this.configuration.toClientConfiguration();
    }

    ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public MssqlConnectionFactoryMetadata getMetadata() {
        return MssqlConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [configuration=").append(this.configuration);
        sb.append(']');
        return sb.toString();
    }

    static class MssqlRoutingException
    extends R2dbcNonTransientResourceException {
        public MssqlRoutingException(String reason) {
            super(reason);
        }
    }
}

