/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message;

import io.netty.buffer.ByteBufUtil;
import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;

public final class TransactionDescriptor {
    public static final int LENGTH = 8;
    private final byte[] descriptor;

    private TransactionDescriptor(byte[] descriptor) {
        Assert.requireNonNull(descriptor, "Descriptor bytes must not be null");
        Assert.isTrue(descriptor.length == 8, "Descriptor must be 8 bytes long");
        this.descriptor = descriptor;
    }

    public static TransactionDescriptor empty() {
        return new TransactionDescriptor(new byte[8]);
    }

    public static TransactionDescriptor from(byte[] descriptor) {
        return new TransactionDescriptor(descriptor);
    }

    public byte[] toBytes() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionDescriptor)) {
            return false;
        }
        TransactionDescriptor that = (TransactionDescriptor)o;
        return Arrays.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Arrays.hashCode(this.descriptor);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [").append(ByteBufUtil.hexDump((byte[])this.descriptor));
        sb.append(']');
        return sb.toString();
    }
}

