/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.r2dbc.mssql.message.type.LengthStrategy;

public enum TdsDataType {
    BIT1(50, LengthStrategy.FIXEDLENTYPE),
    INT8(127, LengthStrategy.FIXEDLENTYPE),
    INT4(56, LengthStrategy.FIXEDLENTYPE),
    INT2(52, LengthStrategy.FIXEDLENTYPE),
    INT1(48, LengthStrategy.FIXEDLENTYPE),
    FLOAT4(59, LengthStrategy.FIXEDLENTYPE),
    FLOAT8(62, LengthStrategy.FIXEDLENTYPE),
    DATETIME4(58, LengthStrategy.FIXEDLENTYPE),
    DATETIME8(61, LengthStrategy.FIXEDLENTYPE),
    MONEY4(122, LengthStrategy.FIXEDLENTYPE),
    MONEY8(60, LengthStrategy.FIXEDLENTYPE),
    BITN(104, LengthStrategy.BYTELENTYPE),
    INTN(38, LengthStrategy.BYTELENTYPE),
    DECIMALN(106, LengthStrategy.BYTELENTYPE),
    NUMERICN(108, LengthStrategy.BYTELENTYPE),
    FLOATN(109, LengthStrategy.BYTELENTYPE),
    MONEYN(110, LengthStrategy.BYTELENTYPE),
    DATETIMEN(111, LengthStrategy.BYTELENTYPE),
    GUID(36, LengthStrategy.BYTELENTYPE),
    DATEN(40, LengthStrategy.BYTELENTYPE),
    TIMEN(41, LengthStrategy.BYTELENTYPE),
    DATETIME2N(42, LengthStrategy.BYTELENTYPE),
    DATETIMEOFFSETN(43, LengthStrategy.BYTELENTYPE),
    BIGCHAR(175, LengthStrategy.USHORTLENTYPE),
    BIGVARCHAR(167, LengthStrategy.USHORTLENTYPE),
    BIGBINARY(173, LengthStrategy.USHORTLENTYPE),
    BIGVARBINARY(165, LengthStrategy.USHORTLENTYPE),
    NCHAR(239, LengthStrategy.USHORTLENTYPE),
    NVARCHAR(231, LengthStrategy.USHORTLENTYPE),
    IMAGE(34, LengthStrategy.PARTLENTYPE),
    TEXT(35, LengthStrategy.PARTLENTYPE),
    NTEXT(99, LengthStrategy.PARTLENTYPE),
    UDT(240, LengthStrategy.PARTLENTYPE),
    XML(241, LengthStrategy.PARTLENTYPE),
    SQL_VARIANT(98, LengthStrategy.LONGLENTYPE);

    private static final int MAXELEMENTS = 256;
    private static final TdsDataType[] cache;
    private final int value;
    private final LengthStrategy lengthStrategy;

    private TdsDataType(int value, LengthStrategy lengthStrategy) {
        this.value = value;
        this.lengthStrategy = lengthStrategy;
    }

    public byte getValue() {
        return (byte)this.value;
    }

    public LengthStrategy getLengthStrategy() {
        return this.lengthStrategy;
    }

    static TdsDataType valueOf(int value) {
        if (value > 256 || value < 0 || cache[value] == null) {
            throw new IllegalArgumentException(String.format("Invalid TDS type: %d", value));
        }
        return cache[value];
    }

    static {
        cache = new TdsDataType[256];
        TdsDataType[] tdsDataTypeArray = TdsDataType.values();
        int n = tdsDataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TdsDataType s;
            TdsDataType.cache[s.value] = s = tdsDataTypeArray[i];
        }
    }
}

