/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import reactor.util.Logger;
import reactor.util.Loggers;

public class ConnectionContext {
    private static final Logger LOGGER = Loggers.getLogger((String)(ConnectionContext.class.getName() + ".context"));
    private static final boolean CONTEXT_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean CHANNEL_ID_ENABLED = LOGGER.isTraceEnabled();
    private static final AtomicLong CONN_ID = new AtomicLong();
    @Nullable
    private final String applicationName;
    @Nullable
    private final UUID connectionId;
    @Nullable
    private final String channelId;
    private final String connectionCounter;
    private final String connectionIdPrefix;

    public ConnectionContext() {
        this.applicationName = null;
        this.connectionId = null;
        this.connectionCounter = this.incrementConnectionCounter();
        this.connectionIdPrefix = this.getConnectionIdPrefix();
        this.channelId = null;
    }

    public ConnectionContext(@Nullable String applicationName, @Nullable UUID connectionId) {
        this.applicationName = applicationName;
        this.connectionId = connectionId;
        this.connectionCounter = this.incrementConnectionCounter();
        this.connectionIdPrefix = this.getConnectionIdPrefix();
        this.channelId = null;
    }

    private ConnectionContext(@Nullable String applicationName, @Nullable UUID connectionId, @Nullable String channelId, String connectionCounter, String connectionIdPrefix) {
        this.applicationName = applicationName;
        this.connectionId = connectionId;
        this.channelId = channelId;
        this.connectionCounter = connectionCounter;
        this.connectionIdPrefix = connectionIdPrefix;
    }

    private String incrementConnectionCounter() {
        return Long.toHexString(CONN_ID.incrementAndGet());
    }

    private String getConnectionIdPrefix() {
        return "[cid: 0x" + this.connectionCounter + "] ";
    }

    public String getMessage(String original) {
        if (CHANNEL_ID_ENABLED) {
            return this.connectionIdPrefix + this.channelId + " " + original;
        }
        if (CONTEXT_ENABLED) {
            return this.connectionIdPrefix + original;
        }
        return original;
    }

    public ConnectionContext withChannelId(String channelId) {
        return new ConnectionContext(this.applicationName, this.connectionId, channelId, this.connectionCounter, this.connectionIdPrefix);
    }
}

