/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.message.ClientMessage;
import io.r2dbc.mssql.message.TransactionDescriptor;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.message.tds.TdsPackets;
import io.r2dbc.mssql.message.token.AllHeaders;
import io.r2dbc.mssql.message.token.TokenStream;
import io.r2dbc.mssql.util.Assert;
import java.util.Objects;

public final class SqlBatch
implements ClientMessage,
TokenStream {
    private final HeaderOptions header;
    private final AllHeaders allHeaders;
    private final String sql;

    private SqlBatch(int outstandingRequests, byte[] transactionDescriptor, String sql) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        Assert.requireNonNull(sql, "SQL must not be null");
        this.header = HeaderOptions.create(Type.SQL_BATCH, Status.empty());
        this.allHeaders = AllHeaders.transactional(transactionDescriptor, outstandingRequests);
        this.sql = sql;
    }

    public static SqlBatch create(int outstandingRequests, TransactionDescriptor transactionDescriptor, String sql) {
        Assert.requireNonNull(transactionDescriptor, "Transaction descriptor must not be null");
        Assert.requireNonNull(sql, "SQL must not be null");
        return new SqlBatch(outstandingRequests, transactionDescriptor.toBytes(), sql);
    }

    @Override
    public TdsFragment encode(ByteBufAllocator allocator, int packetSize) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        int length = this.allHeaders.getLength() + this.sql.length() * 2;
        ByteBuf buffer = allocator.buffer(length);
        this.encode(buffer);
        return TdsPackets.create(this.header, buffer);
    }

    void encode(ByteBuf buffer) {
        this.allHeaders.encode(buffer);
        Encode.unicodeStream(buffer, this.sql);
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public String getName() {
        return "SQLBatch";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlBatch)) {
            return false;
        }
        SqlBatch batch = (SqlBatch)o;
        return Objects.equals(this.allHeaders, batch.allHeaders) && Objects.equals(this.sql, batch.sql);
    }

    public int hashCode() {
        return Objects.hash(this.allHeaders, this.sql);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" [sql=\"").append(this.sql).append('\"');
        sb.append(']');
        return sb.toString();
    }
}

