/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.util.annotation.Nullable;

public enum SqlServerType implements Type
{
    UNKNOWN(Category.UNKNOWN, Object.class, "unknown"),
    TINYINT(Category.NUMERIC, Byte.class, "tinyint", 1, TdsDataType.INTN, TdsDataType.INT1),
    BIT(Category.NUMERIC, Byte.class, "bit", 1, TdsDataType.INTN, TdsDataType.INT1),
    SMALLINT(Category.NUMERIC, Short.class, "smallint", 2, TdsDataType.INTN, TdsDataType.INT2),
    INTEGER(Category.NUMERIC, Integer.class, "int", 4, TdsDataType.INTN, TdsDataType.INT4),
    BIGINT(Category.NUMERIC, Long.class, "bigint", 8, TdsDataType.INTN, TdsDataType.INT8),
    FLOAT(Category.NUMERIC, Double.class, "float", 8, TdsDataType.FLOATN, TdsDataType.FLOAT8),
    REAL(Category.NUMERIC, Float.class, "real", 4, TdsDataType.FLOATN, TdsDataType.FLOAT4),
    SMALLDATETIME(Category.DATETIME, LocalDateTime.class, "smalldatetime", 4, TdsDataType.DATETIMEN, TdsDataType.DATETIME4),
    DATETIME(Category.DATETIME, LocalDateTime.class, "datetime", 8, TdsDataType.DATETIMEN, TdsDataType.DATETIME8),
    DATE(Category.DATE, LocalDate.class, "date", 3, TdsDataType.DATEN, new TdsDataType[0]),
    TIME(Category.TIME, LocalTime.class, "time", 7, TdsDataType.TIMEN, new TdsDataType[0]),
    DATETIME2(Category.DATETIME2, LocalDateTime.class, "datetime2", 7, TdsDataType.DATETIME2N, new TdsDataType[0]),
    DATETIMEOFFSET(Category.DATETIMEOFFSET, OffsetDateTime.class, "datetimeoffset", 7, TdsDataType.DATETIMEOFFSETN, new TdsDataType[0]),
    SMALLMONEY(Category.NUMERIC, BigDecimal.class, "smallmoney", 4, TdsDataType.MONEYN, TdsDataType.MONEY4),
    MONEY(Category.NUMERIC, BigDecimal.class, "money", 8, TdsDataType.MONEYN, TdsDataType.MONEY8),
    CHAR(Category.CHARACTER, String.class, "char"),
    VARCHAR(Category.CHARACTER, String.class, "varchar", 8000, TdsDataType.BIGVARCHAR, new TdsDataType[0]),
    VARCHARMAX(Category.LONG_CHARACTER, String.class, "varchar", TdsDataType.BIGVARCHAR, new TdsDataType[0]),
    TEXT(Category.LONG_CHARACTER, Clob.class, "text", TdsDataType.TEXT, new TdsDataType[0]),
    NCHAR(Category.NCHARACTER, String.class, "nchar"),
    NVARCHAR(Category.NCHARACTER, String.class, "nvarchar", 4000, TdsDataType.NVARCHAR, new TdsDataType[0]),
    NVARCHARMAX(Category.LONG_NCHARACTER, String.class, "nvarchar", TdsDataType.NVARCHAR, new TdsDataType[0]),
    NTEXT(Category.LONG_NCHARACTER, String.class, "ntext", TdsDataType.NTEXT, new TdsDataType[0]),
    BINARY(Category.BINARY, ByteBuffer.class, "binary"),
    VARBINARY(Category.BINARY, ByteBuffer.class, "varbinary", 8000, TdsDataType.BIGVARBINARY, new TdsDataType[0]),
    VARBINARYMAX(Category.LONG_BINARY, ByteBuffer.class, "varbinary", TdsDataType.BIGVARBINARY, new TdsDataType[0]),
    IMAGE(Category.LONG_BINARY, ByteBuffer.class, "image", TdsDataType.IMAGE, new TdsDataType[0]),
    DECIMAL(Category.NUMERIC, BigDecimal.class, "decimal", 38, TdsDataType.DECIMALN, new TdsDataType[0]),
    NUMERIC(Category.NUMERIC, BigDecimal.class, "numeric", 38, TdsDataType.NUMERICN, new TdsDataType[0]),
    GUID(Category.GUID, UUID.class, "uniqueidentifier", 16, TdsDataType.GUID, new TdsDataType[0]),
    SQL_VARIANT(Category.SQL_VARIANT, Object.class, "sql_variant", TdsDataType.SQL_VARIANT, new TdsDataType[0]),
    UDT(Category.UDT, Object.class, "udt"),
    XML(Category.XML, Object.class, "xml"),
    TIMESTAMP(Category.TIMESTAMP, byte[].class, "timestamp", 8, TdsDataType.BIGBINARY, new TdsDataType[0]),
    GEOMETRY(Category.UDT, Object.class, "geometry"),
    GEOGRAPHY(Category.UDT, Object.class, "geography");

    private final Category category;
    private final Class<?> defaultJavaType;
    private final String name;
    private final int maxLength;
    @Nullable
    private final TdsDataType nullableType;
    private final TdsDataType[] fixedTypes;

    private SqlServerType(Category category, Class<?> defaultJavaType, String name, TdsDataType nullableType, TdsDataType ... fixedTypes) {
        this(category, defaultJavaType, name, 0, nullableType, fixedTypes);
    }

    private SqlServerType(Category category, Class<?> defaultJavaType, String name, int maxLength, TdsDataType nullableType, TdsDataType ... fixedTypes) {
        Assert.isTrue(nullableType.getLengthStrategy() != LengthStrategy.FIXEDLENTYPE, String.format("Type [%s] specified a fixed-length strategy in its nullable type", name));
        for (TdsDataType fixedType : fixedTypes) {
            Assert.isTrue(fixedType.getLengthStrategy() == LengthStrategy.FIXEDLENTYPE, String.format("Type [%s] specified [%s] in its fixed length type [%s] ", new Object[]{name, fixedType.getLengthStrategy(), fixedType}));
        }
        this.category = category;
        this.defaultJavaType = defaultJavaType;
        this.name = name;
        this.maxLength = maxLength;
        this.nullableType = nullableType;
        this.fixedTypes = fixedTypes;
    }

    private SqlServerType(Category category, Class<?> defaultJavaType, String name) {
        this.category = category;
        this.defaultJavaType = defaultJavaType;
        this.name = name;
        this.maxLength = 0;
        this.nullableType = null;
        this.fixedTypes = new TdsDataType[0];
    }

    public static SqlServerType of(String typeName) {
        for (SqlServerType type : SqlServerType.values()) {
            if (!type.name.equalsIgnoreCase(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unknown type: %s", typeName));
    }

    public static SqlServerType of(R2dbcType type) {
        switch (type) {
            case CHAR: {
                return CHAR;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case NCHAR: {
                return NCHAR;
            }
            case NVARCHAR: {
                return NVARCHAR;
            }
            case CLOB: {
                return TEXT;
            }
            case NCLOB: {
                return NTEXT;
            }
            case BOOLEAN: {
                return TINYINT;
            }
            case BINARY: {
                return BINARY;
            }
            case VARBINARY: {
                return VARBINARY;
            }
            case BLOB: {
                return IMAGE;
            }
            case INTEGER: {
                return INTEGER;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case NUMERIC: {
                return NUMERIC;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case FLOAT: 
            case DOUBLE: {
                return FLOAT;
            }
            case REAL: {
                return REAL;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                return TIME;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
    }

    public Category getCategory() {
        return this.category;
    }

    public Class<?> getJavaType() {
        return this.defaultJavaType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public TdsDataType getNullableType() {
        return this.nullableType;
    }

    public TdsDataType[] getFixedTypes() {
        return this.fixedTypes;
    }

    public String toString() {
        return this.name;
    }

    public static enum Category {
        BINARY,
        CHARACTER,
        DATE,
        DATETIME,
        DATETIME2,
        DATETIMEOFFSET,
        GUID,
        LONG_BINARY,
        LONG_CHARACTER,
        LONG_NCHARACTER,
        NCHARACTER,
        NUMERIC,
        UNKNOWN,
        TIME,
        TIMESTAMP,
        UDT,
        SQL_VARIANT,
        XML;

    }
}

