/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.pool.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class OptionMapper {
    private final ConnectionFactoryOptions options;

    private OptionMapper(ConnectionFactoryOptions options) {
        this.options = options;
    }

    public static OptionMapper create(ConnectionFactoryOptions options) {
        return new OptionMapper(options);
    }

    public <T> Source<T> from(Option<T> option) {
        if (this.options.hasOption(option)) {
            return new AvailableSource(() -> this.options.getRequiredValue(option), option.name());
        }
        return NullSource.instance();
    }

    static int toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s into integer", value));
    }

    static <T extends Enum<T>> T toEnum(Object value, Class<T> enumType) {
        if (enumType.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            return Enum.valueOf(enumType, value.toString().toUpperCase(Locale.ENGLISH));
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s into %s", value, enumType.getName()));
    }

    static Duration toDuration(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof String) {
            return Duration.parse(value.toString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s into Duration", value));
    }

    private static class AvailableSource<T>
    implements Source<T> {
        private final Supplier<T> supplier;
        private final String optionName;

        private AvailableSource(Supplier<T> supplier, String optionName) {
            this.supplier = supplier;
            this.optionName = optionName;
        }

        @Override
        public <R> Source<R> as(Function<Object, R> mappingFunction) {
            Assert.requireNonNull(mappingFunction, "Mapping function must not be null");
            Supplier<Object> supplier = () -> mappingFunction.apply(this.supplier.get());
            return new AvailableSource<Object>(supplier, this.optionName);
        }

        @Override
        public void to(Consumer<T> consumer) {
            Assert.requireNonNull(consumer, "Consumer must not be null");
            try {
                T value = this.supplier.get();
                if (value != null) {
                    consumer.accept(value);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot assign option %s", this.optionName), e);
            }
        }
    }

    private static enum NullSource implements Source<Object>
    {
        INSTANCE;


        public static <T> Source<T> instance() {
            return INSTANCE;
        }

        @Override
        public <R> Source<R> as(Function<Object, R> mappingFunction) {
            return this;
        }

        @Override
        public void to(Consumer<Object> consumer) {
        }
    }

    public static interface Source<T> {
        public <R> Source<R> as(Function<Object, R> var1);

        public void to(Consumer<T> var1);
    }
}

