/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.holder.ObjectHolder;
import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.context.ApplicationContext;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final String INTERCEPT_METHOD_PREFIX = "get";

    public Configuration provide(final Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(originalConfiguration.getClass(), (Callback)new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (method.getName().startsWith(SpringBootConfigurationProvider.INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                    Object result = null;
                    String rawDataId = (String)args[0];
                    if (args.length == 1) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId));
                    } else if (args.length == 2) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1]);
                    } else if (args.length == 3) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1], (Long)args[2]);
                    }
                    if (result != null) {
                        if (method.getReturnType().equals(String.class)) {
                            return String.valueOf(result);
                        }
                        return result;
                    }
                }
                return method.invoke((Object)originalConfiguration, args);
            }
        });
    }

    private Object get(String dataId, Object defaultValue, long timeoutMills) throws IllegalAccessException, InstantiationException {
        return this.get(dataId, defaultValue);
    }

    private Object get(String dataId, Object defaultValue) throws IllegalAccessException, InstantiationException {
        Object result = this.get(dataId);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private Object get(String dataId) throws IllegalAccessException, InstantiationException {
        String propertyPrefix = this.getPropertyPrefix(dataId);
        String propertySuffix = this.getPropertySuffix(dataId);
        ApplicationContext applicationContext = (ApplicationContext)ObjectHolder.INSTANCE.getObject("springApplicationContext");
        Class<?> propertyClass = StarterConstants.PROPERTY_BEAN_MAP.get(propertyPrefix);
        Object valueObject = null;
        if (propertyClass != null) {
            try {
                Object propertyBean = applicationContext.getBean(propertyClass);
                valueObject = this.getFieldValue(propertyBean, propertySuffix, dataId);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        } else {
            throw new ShouldNeverHappenException("PropertyClass for prefix: [" + propertyPrefix + "] should not be null.");
        }
        if (valueObject == null) {
            valueObject = this.getFieldValue(propertyClass.newInstance(), propertySuffix, dataId);
        }
        return valueObject;
    }

    private Object getFieldValue(Object object, String fieldName, String dataId) throws IllegalAccessException {
        Object value = null;
        Optional<Field> fieldOptional = Stream.of(object.getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(fieldName)).findAny();
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            value = field.get(object);
            if (value instanceof Map) {
                String key = StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
                value = ((Map)value).get(key);
            }
        }
        return value;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = StringUtils.removeEnd((String)rawDataId, (String)".grouplist");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }
}

