/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;

public class GenericRequestor
extends Requestor {
    public GenericRequestor(Protocol protocol, Transceiver transceiver) throws IOException {
        super(protocol, transceiver);
    }

    @Override
    public Object request(String messageName, Object request) throws IOException {
        try {
            return super.request(messageName, request);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new AvroRemoteException(e);
        }
    }

    @Override
    public void writeRequest(Schema schema, Object request, Encoder out) throws IOException {
        new GenericDatumWriter<Object>(schema).write(request, out);
    }

    @Override
    public Object readResponse(Schema schema, Decoder in) throws IOException {
        return new GenericDatumReader<Object>(schema).read(null, in);
    }

    @Override
    public Exception readError(Schema schema, Decoder in) throws IOException {
        Object error = new GenericDatumReader<Object>(schema).read(null, in);
        if (error instanceof CharSequence) {
            return new AvroRuntimeException(error.toString());
        }
        return new AvroRemoteException(error);
    }
}

