/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.Destroyable;
import org.apache.dubbo.rpc.service.EchoService;
import org.apache.dubbo.rpc.service.GenericService;

public abstract class AbstractProxyFactory
implements ProxyFactory {
    private static final Class<?>[] INTERNAL_INTERFACES = new Class[]{EchoService.class, Destroyable.class};

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        return this.getProxy(invoker, false);
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, boolean generic) throws RpcException {
        LinkedHashSet interfaces = new LinkedHashSet();
        String config = invoker.getUrl().getParameter("interfaces");
        if (config != null && config.length() > 0) {
            String[] types;
            for (String type : types = CommonConstants.COMMA_SPLIT_PATTERN.split(config)) {
                interfaces.add(ReflectUtils.forName((String)type));
            }
        }
        if (generic) {
            if (GenericService.class.equals(invoker.getInterface()) || !GenericService.class.isAssignableFrom(invoker.getInterface())) {
                interfaces.add(com.alibaba.dubbo.rpc.service.GenericService.class);
            }
            try {
                String realInterface = invoker.getUrl().getParameter("interface");
                interfaces.add(ReflectUtils.forName((String)realInterface));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        interfaces.add(invoker.getInterface());
        interfaces.addAll(Arrays.asList(INTERNAL_INTERFACES));
        return this.getProxy(invoker, interfaces.toArray(new Class[0]));
    }

    public static Class<?>[] getInternalInterfaces() {
        return (Class[])INTERNAL_INTERFACES.clone();
    }

    public abstract <T> T getProxy(Invoker<T> var1, Class<?>[] var2);
}

