/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.cli.CancelOptions;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.client.cli.InfoOptions;
import org.apache.flink.client.cli.ListOptions;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.cli.RunOptions;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.yarn.AbstractFlinkYarnClient;
import org.apache.flink.runtime.yarn.AbstractFlinkYarnCluster;
import org.apache.flink.runtime.yarn.FlinkYarnClusterStatus;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class CliFrontend {
    private static final String ACTION_RUN = "run";
    private static final String ACTION_INFO = "info";
    private static final String ACTION_LIST = "list";
    private static final String ACTION_CANCEL = "cancel";
    private static final String ENV_CONFIG_DIRECTORY = "FLINK_CONF_DIR";
    private static final String CONFIG_DIRECTORY_FALLBACK_1 = "../conf";
    private static final String CONFIG_DIRECTORY_FALLBACK_2 = "conf";
    public static final String YARN_PROPERTIES_FILE = ".yarn-properties";
    public static final String YARN_PROPERTIES_JOBMANAGER_KEY = "jobManager";
    public static final String YARN_PROPERTIES_PARALLELISM = "parallelism";
    public static final String YARN_PROPERTIES_DYNAMIC_PROPERTIES_STRING = "dynamicPropertiesString";
    public static final String YARN_DYNAMIC_PROPERTIES_SEPARATOR = "@@";
    public static final String YARN_DEPLOY_JOBMANAGER = "yarn-cluster";
    private static final Logger LOG = LoggerFactory.getLogger(CliFrontend.class);
    private final File configDirectory;
    private final Configuration config;
    private final FiniteDuration askTimeout;
    private final FiniteDuration lookupTimeout;
    private InetSocketAddress jobManagerAddress;
    private ActorSystem actorSystem;
    private AbstractFlinkYarnCluster yarnCluster;

    public CliFrontend() throws Exception {
        this(CliFrontend.getConfigurationDirectoryFromEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliFrontend(String configDir) throws Exception {
        this.configDirectory = new File(configDir);
        LOG.info("Using configuration directory " + this.configDirectory.getAbsolutePath());
        LOG.info("Trying to load configuration file");
        GlobalConfiguration.loadConfiguration((String)this.configDirectory.getAbsolutePath());
        this.config = GlobalConfiguration.getConfiguration();
        File propertiesFile = new File(this.configDirectory, YARN_PROPERTIES_FILE);
        if (propertiesFile.exists()) {
            String address;
            this.logAndSysout("Found YARN properties file " + propertiesFile.getAbsolutePath());
            Properties yarnProperties = new Properties();
            try {
                FileInputStream is = new FileInputStream(propertiesFile);
                try {
                    yarnProperties.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                throw new Exception("Cannot read the YARN properties file", e);
            }
            String propParallelism = yarnProperties.getProperty(YARN_PROPERTIES_PARALLELISM);
            if (propParallelism != null) {
                try {
                    int parallelism = Integer.parseInt(propParallelism);
                    this.config.setInteger("parallelism.default", parallelism);
                    this.logAndSysout("YARN properties set default parallelism to " + parallelism);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Error while parsing the YARN properties: Property parallelism is not an integer.");
                }
            }
            if ((address = yarnProperties.getProperty(YARN_PROPERTIES_JOBMANAGER_KEY)) != null) {
                try {
                    this.jobManagerAddress = CliFrontend.parseJobManagerAddress(address);
                }
                catch (Exception e) {
                    throw new Exception("YARN properties contain an invalid entry for JobManager address.", e);
                }
                this.logAndSysout("Using JobManager address from YARN properties " + this.jobManagerAddress);
            }
            String dynamicPropertiesEncoded = yarnProperties.getProperty(YARN_PROPERTIES_DYNAMIC_PROPERTIES_STRING);
            List<Tuple2<String, String>> dynamicProperties = CliFrontend.getDynamicProperties(dynamicPropertiesEncoded);
            for (Tuple2<String, String> dynamicProperty : dynamicProperties) {
                this.config.setString((String)dynamicProperty.f0, (String)dynamicProperty.f1);
            }
        }
        this.askTimeout = AkkaUtils.getTimeout((Configuration)this.config);
        this.lookupTimeout = AkkaUtils.getLookupTimeout((Configuration)this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run(String[] args) {
        int n;
        PackagedProgram program;
        RunOptions options;
        LOG.info("Running 'run' command.");
        try {
            options = CliFrontendParser.parseRunCommand(args);
        }
        catch (CliArgsException e) {
            return this.handleArgException(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (options.isPrintHelp()) {
            CliFrontendParser.printHelpForRun();
            return 0;
        }
        if (options.getJarFilePath() == null) {
            return this.handleArgException(new CliArgsException("The program JAR file was not specified."));
        }
        try {
            LOG.info("Building program from JAR file");
            program = this.buildProgram(options);
        }
        catch (FileNotFoundException e) {
            return this.handleArgException(e);
        }
        catch (ProgramInvocationException e) {
            return this.handleError(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        int exitCode = 1;
        try {
            int userParallelism = options.getParallelism();
            LOG.debug("User parallelism is set to {}", (Object)userParallelism);
            Client client = this.getClient(options, program.getUserCodeClassLoader(), program.getMainClassName(), userParallelism);
            LOG.debug("Client slots is set to {}", (Object)client.getMaxSlots());
            if (client.getMaxSlots() != -1 && userParallelism == -1) {
                this.logAndSysout("Using the parallelism provided by the remote cluster (" + client.getMaxSlots() + "). " + "To use another parallelism, set it at the ./bin/flink client.");
                userParallelism = client.getMaxSlots();
            }
            if (this.yarnCluster != null && this.yarnCluster.isDetached()) {
                this.logAndSysout("The Flink YARN client has been started in detached mode. In order to stop Flink on YARN, use the following command or a YARN web interface to stop it:\nyarn application -kill " + this.yarnCluster.getApplicationId() + "\n" + "Please also note that the temporary files of the YARN session in the home directoy will not be removed.");
                exitCode = this.executeProgram(program, client, userParallelism, false);
            } else {
                exitCode = this.executeProgram(program, client, userParallelism, true);
            }
            if (this.yarnCluster != null && !this.yarnCluster.isDetached()) {
                List msgs = this.yarnCluster.getNewMessages();
                if (msgs != null && msgs.size() > 1) {
                    this.logAndSysout("The following messages were created by the YARN cluster while running the Job:");
                    for (String msg : msgs) {
                        this.logAndSysout(msg);
                    }
                }
                if (this.yarnCluster.hasFailed()) {
                    this.logAndSysout("YARN cluster is in failed state!");
                    this.logAndSysout("YARN Diagnostics: " + this.yarnCluster.getDiagnostics());
                }
            }
            n = exitCode;
        }
        catch (Throwable t) {
            int n2;
            try {
                n2 = this.handleError(t);
            }
            catch (Throwable throwable) {
                if (this.yarnCluster != null && !this.yarnCluster.isDetached()) {
                    this.logAndSysout("Shutting down YARN cluster");
                    this.yarnCluster.shutdown(exitCode != 0);
                }
                if (program != null) {
                    program.deleteExtractedLibraries();
                }
                throw throwable;
            }
            if (this.yarnCluster != null && !this.yarnCluster.isDetached()) {
                this.logAndSysout("Shutting down YARN cluster");
                this.yarnCluster.shutdown(exitCode != 0);
            }
            if (program != null) {
                program.deleteExtractedLibraries();
            }
            return n2;
        }
        if (this.yarnCluster != null && !this.yarnCluster.isDetached()) {
            this.logAndSysout("Shutting down YARN cluster");
            this.yarnCluster.shutdown(exitCode != 0);
        }
        if (program != null) {
            program.deleteExtractedLibraries();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int info(String[] args) {
        PackagedProgram program;
        InfoOptions options;
        LOG.info("Running 'info' command.");
        try {
            options = CliFrontendParser.parseInfoCommand(args);
        }
        catch (CliArgsException e) {
            return this.handleArgException(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (options.isPrintHelp()) {
            CliFrontendParser.printHelpForInfo();
            return 0;
        }
        if (options.getJarFilePath() == null) {
            return this.handleArgException(new CliArgsException("The program JAR file was not specified."));
        }
        try {
            LOG.info("Building program from JAR file");
            program = this.buildProgram(options);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        try {
            int parallelism = options.getParallelism();
            LOG.info("Creating program plan dump");
            Client client = this.getClient(options, program.getUserCodeClassLoader(), program.getMainClassName(), parallelism);
            String jsonPlan = client.getOptimizedPlanAsJson(program, parallelism);
            if (jsonPlan != null) {
                System.out.println("----------------------- Execution Plan -----------------------");
                System.out.println(jsonPlan);
                System.out.println("--------------------------------------------------------------");
            } else {
                System.out.println("JSON plan could not be generated.");
            }
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            int n = this.handleError(t);
            return n;
        }
        finally {
            program.deleteExtractedLibraries();
        }
    }

    protected int list(String[] args) {
        ListOptions options;
        LOG.info("Running 'list' command.");
        try {
            options = CliFrontendParser.parseListCommand(args);
        }
        catch (CliArgsException e) {
            return this.handleArgException(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (options.isPrintHelp()) {
            CliFrontendParser.printHelpForList();
            return 0;
        }
        boolean running = options.getRunning();
        boolean scheduled = options.getScheduled();
        if (!running && !scheduled) {
            running = true;
            scheduled = true;
        }
        try {
            Object result;
            ActorRef jobManager = this.getJobManager(options);
            LOG.info("Connecting to JobManager to retrieve list of jobs");
            Future response = Patterns.ask((ActorRef)jobManager, (Object)JobManagerMessages.getRequestRunningJobsStatus(), (Timeout)new Timeout(this.askTimeout));
            try {
                result = Await.result((Awaitable)response, (Duration)this.askTimeout);
            }
            catch (Exception e) {
                throw new Exception("Could not retrieve running jobs from the JobManager.", e);
            }
            if (result instanceof JobManagerMessages.RunningJobsStatus) {
                LOG.info("Successfully retrieved list of jobs");
                List jobs = ((JobManagerMessages.RunningJobsStatus)result).getStatusMessages();
                ArrayList<JobStatusMessage> runningJobs = null;
                ArrayList<JobStatusMessage> scheduledJobs = null;
                if (running) {
                    runningJobs = new ArrayList<JobStatusMessage>();
                }
                if (scheduled) {
                    scheduledJobs = new ArrayList<JobStatusMessage>();
                }
                for (JobStatusMessage rj : jobs) {
                    if (running && rj.getJobState().equals((Object)JobStatus.RUNNING)) {
                        runningJobs.add(rj);
                    }
                    if (!scheduled || !rj.getJobState().equals((Object)JobStatus.CREATED)) continue;
                    scheduledJobs.add(rj);
                }
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                Comparator<JobStatusMessage> njec = new Comparator<JobStatusMessage>(){

                    @Override
                    public int compare(JobStatusMessage o1, JobStatusMessage o2) {
                        return (int)(o1.getStartTime() - o2.getStartTime());
                    }
                };
                if (running) {
                    if (runningJobs.size() == 0) {
                        System.out.println("No running jobs.");
                    } else {
                        Collections.sort(runningJobs, njec);
                        System.out.println("------------------------ Running Jobs ------------------------");
                        for (JobStatusMessage rj : runningJobs) {
                            System.out.println(df.format(new Date(rj.getStartTime())) + " : " + rj.getJobId() + " : " + rj.getJobName());
                        }
                        System.out.println("--------------------------------------------------------------");
                    }
                }
                if (scheduled) {
                    if (scheduledJobs.size() == 0) {
                        System.out.println("No scheduled jobs.");
                    } else {
                        Collections.sort(scheduledJobs, njec);
                        System.out.println("----------------------- Scheduled Jobs -----------------------");
                        for (JobStatusMessage rj : scheduledJobs) {
                            System.out.println(df.format(new Date(rj.getStartTime())) + " : " + rj.getJobId() + " : " + rj.getJobName());
                        }
                        System.out.println("--------------------------------------------------------------");
                    }
                }
                return 0;
            }
            throw new Exception("ReqeustRunningJobs requires a response of type RunningJobs. Instead the response is of type " + result.getClass() + ".");
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    protected int cancel(String[] args) {
        JobID jobId;
        CancelOptions options;
        LOG.info("Running 'cancel' command.");
        try {
            options = CliFrontendParser.parseCancelCommand(args);
        }
        catch (CliArgsException e) {
            return this.handleArgException(e);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (options.isPrintHelp()) {
            CliFrontendParser.printHelpForCancel();
            return 0;
        }
        String[] cleanedArgs = options.getArgs();
        if (cleanedArgs.length > 0) {
            String jobIdString = cleanedArgs[0];
            try {
                jobId = new JobID(StringUtils.hexStringToByte((String)jobIdString));
            }
            catch (Exception e) {
                LOG.error("Error: The value for the Job ID is not a valid ID.");
                System.out.println("Error: The value for the Job ID is not a valid ID.");
                return 1;
            }
        } else {
            LOG.error("Missing JobID in the command line arguments.");
            System.out.println("Error: Specify a Job ID to cancel a job.");
            return 1;
        }
        try {
            ActorRef jobManager = this.getJobManager(options);
            Future response = Patterns.ask((ActorRef)jobManager, (Object)new JobManagerMessages.CancelJob(jobId), (Timeout)new Timeout(this.askTimeout));
            try {
                Await.result((Awaitable)response, (Duration)this.askTimeout);
                return 0;
            }
            catch (Exception e) {
                throw new Exception("Canceling the job with ID " + jobId + " failed.", e);
            }
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeProgram(PackagedProgram program, Client client, int parallelism, boolean wait) {
        JobSubmissionResult execResult;
        LOG.info("Starting execution of program");
        try {
            client.setPrintStatusDuringExecution(true);
            execResult = client.run(program, parallelism, wait);
        }
        catch (ProgramInvocationException e) {
            int n = this.handleError(e);
            return n;
        }
        finally {
            program.deleteExtractedLibraries();
        }
        if (wait) {
            LOG.info("Program execution finished");
        }
        if (execResult != null) {
            if (this.yarnCluster != null && this.yarnCluster.isDetached()) {
                if (execResult.getJobID() == null) {
                    throw new RuntimeException("Error while starting job. No Job ID set.");
                }
                this.yarnCluster.stopAfterJob(execResult.getJobID());
                this.yarnCluster.disconnect();
                System.out.println("The Job has been submitted with JobID " + execResult.getJobID());
                return 0;
            }
            if (execResult instanceof JobExecutionResult) {
                JobExecutionResult result = (JobExecutionResult)execResult;
                System.out.println("Job Runtime: " + result.getNetRuntime() + " ms");
                Map accumulatorsResult = result.getAllAccumulatorResults();
                if (accumulatorsResult.size() > 0) {
                    System.out.println("Accumulator Results: ");
                    System.out.println(AccumulatorHelper.getResultsFormated((Map)accumulatorsResult));
                }
            } else {
                LOG.info("The Job did not return an execution result");
            }
        }
        return 0;
    }

    protected PackagedProgram buildProgram(ProgramOptions options) throws FileNotFoundException, ProgramInvocationException {
        String[] programArgs = options.getProgramArgs();
        String jarFilePath = options.getJarFilePath();
        if (jarFilePath == null) {
            throw new IllegalArgumentException("The program JAR file was not specified.");
        }
        File jarFile = new File(jarFilePath);
        if (!jarFile.exists()) {
            throw new FileNotFoundException("JAR file does not exist: " + jarFile);
        }
        if (!jarFile.isFile()) {
            throw new FileNotFoundException("JAR file is not a file: " + jarFile);
        }
        String entryPointClass = options.getEntryPointClassName();
        return entryPointClass == null ? new PackagedProgram(jarFile, programArgs) : new PackagedProgram(jarFile, entryPointClass, programArgs);
    }

    protected InetSocketAddress getJobManagerAddress(CommandLineOptions options) throws Exception {
        if (options.getJobManagerAddress() != null) {
            return CliFrontend.parseJobManagerAddress(options.getJobManagerAddress());
        }
        if (this.jobManagerAddress == null) {
            int jobManagerPort;
            String jobManagerHost = this.config.getString("jobmanager.rpc.address", null);
            if (jobManagerHost == null) {
                throw new Exception("Found no configuration in the config directory '" + this.configDirectory + "' that specifies the JobManager address.");
            }
            try {
                jobManagerPort = this.config.getInteger("jobmanager.rpc.port", -1);
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid value for the JobManager port (jobmanager.rpc.port) in the configuration.");
            }
            if (jobManagerPort == -1) {
                throw new Exception("Found no configuration in the config directory '" + this.configDirectory + "' that specifies the JobManager port.");
            }
            this.jobManagerAddress = new InetSocketAddress(jobManagerHost, jobManagerPort);
        }
        return this.jobManagerAddress;
    }

    protected ActorRef getJobManager(CommandLineOptions options) throws Exception {
        InetSocketAddress address = this.getJobManagerAddress(options);
        if (this.actorSystem == null) {
            LOG.info("Starting actor system to communicate with JobManager");
            try {
                scala.Tuple2 systemEndpoint = new scala.Tuple2((Object)"", (Object)0);
                this.actorSystem = AkkaUtils.createActorSystem((Configuration)this.config, (Option)new Some((Object)systemEndpoint));
            }
            catch (Exception e) {
                throw new IOException("Could not start actor system to communicate with JobManager", e);
            }
            LOG.info("Actor system successfully started");
        }
        LOG.info("Trying to lookup JobManager");
        ActorRef jmActor = JobManager.getJobManagerRemoteReference((InetSocketAddress)address, (ActorSystem)this.actorSystem, (FiniteDuration)this.lookupTimeout);
        LOG.info("JobManager is at " + jmActor.path());
        return jmActor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Client getClient(CommandLineOptions options, ClassLoader classLoader, String programName, int userParallelism) throws Exception {
        InetSocketAddress jobManagerAddress;
        int maxSlots = -1;
        if (!YARN_DEPLOY_JOBMANAGER.equals(options.getJobManagerAddress())) {
            jobManagerAddress = this.getJobManagerAddress(options);
            return new Client(jobManagerAddress, this.config, classLoader, maxSlots);
        }
        this.logAndSysout("YARN cluster mode detected. Switching Log4j output to console");
        CommandLine commandLine = options.getCommandLine();
        AbstractFlinkYarnClient flinkYarnClient = CliFrontendParser.getFlinkYarnSessionCli().createFlinkYarnClient(commandLine);
        flinkYarnClient.setName("Flink Application: " + programName);
        if (flinkYarnClient == null) {
            throw new RuntimeException("Unable to create Flink YARN Client. Check previous log messages");
        }
        int yarnTmSlots = flinkYarnClient.getTaskManagerSlots();
        if (yarnTmSlots == -1) {
            yarnTmSlots = 1;
        }
        maxSlots = yarnTmSlots * flinkYarnClient.getTaskManagerCount();
        if (userParallelism != -1) {
            int slotsPerTM = userParallelism / flinkYarnClient.getTaskManagerCount();
            this.logAndSysout("The YARN cluster has " + maxSlots + " slots available, but the user requested a parallelism of " + userParallelism + " on YARN. " + "Each of the " + flinkYarnClient.getTaskManagerCount() + " TaskManagers will get " + slotsPerTM + " slots.");
            flinkYarnClient.setTaskManagerSlots(slotsPerTM);
        }
        try {
            this.yarnCluster = flinkYarnClient.deploy();
            this.yarnCluster.connectToCluster();
        }
        catch (Exception e) {
            throw new RuntimeException("Error deploying the YARN cluster", e);
        }
        jobManagerAddress = this.yarnCluster.getJobManagerAddress();
        this.logAndSysout("YARN cluster started");
        this.logAndSysout("JobManager web interface address " + this.yarnCluster.getWebInterfaceURL());
        this.logAndSysout("Waiting until all TaskManagers have connected");
        while (true) {
            FlinkYarnClusterStatus status;
            if ((status = this.yarnCluster.getClusterStatus()) != null) {
                if (status.getNumberOfTaskManagers() >= flinkYarnClient.getTaskManagerCount()) {
                    this.logAndSysout("All TaskManagers are connected");
                    return new Client(jobManagerAddress, this.config, classLoader, maxSlots);
                }
                this.logAndSysout("TaskManager status (" + status.getNumberOfTaskManagers() + "/" + flinkYarnClient.getTaskManagerCount() + ")");
            } else {
                this.logAndSysout("No status updates from the YARN cluster received so far. Waiting ...");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for TaskManagers");
                System.err.println("Thread is interrupted");
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private int handleArgException(Exception e) {
        LOG.error("Invalid command line arguments." + (e.getMessage() == null ? "" : e.getMessage()));
        System.out.println(e.getMessage());
        System.out.println();
        System.out.println("Use the help option (-h or --help) to get help on the command.");
        return 1;
    }

    private int handleError(Throwable t) {
        LOG.error("Error while running the command.", t);
        t.printStackTrace();
        System.err.println();
        System.err.println("The exception above occurred while trying to run your command.");
        return 1;
    }

    private void logAndSysout(String message) {
        LOG.info(message);
        System.out.println(message);
    }

    public int parseParameters(String[] args) {
        if (args.length < 1) {
            CliFrontendParser.printHelp();
            System.out.println("Please specify an action.");
            return 1;
        }
        String action = args[0];
        final String[] params = Arrays.copyOfRange(args, 1, args.length);
        if (action.equals(ACTION_RUN)) {
            if (SecurityUtils.isSecurityEnabled()) {
                String message = "Secure Hadoop environment setup detected. Running in secure context.";
                LOG.info(message);
                System.out.println(message);
                try {
                    return (Integer)SecurityUtils.runSecured((SecurityUtils.FlinkSecuredRunner)new SecurityUtils.FlinkSecuredRunner<Integer>(){

                        public Integer run() throws Exception {
                            return CliFrontend.this.run(params);
                        }
                    });
                }
                catch (Exception e) {
                    this.handleError(e);
                }
            }
            return this.run(params);
        }
        if (action.equals(ACTION_LIST)) {
            return this.list(params);
        }
        if (action.equals(ACTION_INFO)) {
            return this.info(params);
        }
        if (action.equals(ACTION_CANCEL)) {
            return this.cancel(params);
        }
        if (action.equals("-h") || action.equals("--help")) {
            CliFrontendParser.printHelp();
            return 0;
        }
        System.out.printf("\"%s\" is not a valid action.\n", action);
        System.out.println();
        System.out.println("Valid actions are \"run\", \"list\", \"info\", or \"cancel\".");
        System.out.println();
        System.out.println("Specify the help option (-h or --help) to get help on the command.");
        return 1;
    }

    public void shutdown() {
        ActorSystem sys = this.actorSystem;
        if (sys != null) {
            this.actorSystem = null;
            sys.shutdown();
        }
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"Command Line Client", (String[])args);
        EnvironmentInformation.checkJavaVersion();
        try {
            CliFrontend cli = new CliFrontend();
            int retCode = cli.parseParameters(args);
            System.exit(retCode);
        }
        catch (Throwable t) {
            LOG.error("Fatal error while running command line interface.", t);
            t.printStackTrace();
            System.exit(31);
        }
    }

    private static InetSocketAddress parseJobManagerAddress(String hostAndPort) {
        URI uri;
        try {
            uri = new URI("my://" + hostAndPort);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed address " + hostAndPort, e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || port == -1) {
            throw new RuntimeException("Address is missing hostname or port " + hostAndPort);
        }
        return new InetSocketAddress(host, port);
    }

    public static String getConfigurationDirectoryFromEnv() {
        String location = System.getenv(ENV_CONFIG_DIRECTORY);
        if (location != null) {
            if (new File(location).exists()) {
                return location;
            }
            throw new RuntimeException("The config directory '" + location + "', specified in the '" + ENV_CONFIG_DIRECTORY + "' environment variable, does not exist.");
        }
        if (new File(CONFIG_DIRECTORY_FALLBACK_1).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_1;
        } else if (new File(CONFIG_DIRECTORY_FALLBACK_2).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_2;
        } else {
            throw new RuntimeException("The configuration directory was not specified. Please specify the directory containing the configuration file through the 'FLINK_CONF_DIR' environment variable.");
        }
        return location;
    }

    public static List<Tuple2<String, String>> getDynamicProperties(String dynamicPropertiesEncoded) {
        ArrayList<Tuple2<String, String>> ret = new ArrayList<Tuple2<String, String>>();
        if (dynamicPropertiesEncoded != null && dynamicPropertiesEncoded.length() > 0) {
            String[] propertyLines;
            for (String propLine : propertyLines = dynamicPropertiesEncoded.split(YARN_DYNAMIC_PROPERTIES_SEPARATOR)) {
                String[] kv;
                if (propLine == null || (kv = propLine.split("=")).length < 2 || kv[0] == null || kv[1] == null || kv[0].length() <= 0) continue;
                ret.add((Tuple2<String, String>)new Tuple2((Object)kv[0], (Object)kv[1]));
            }
        }
        return ret;
    }
}

