/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;

public abstract class ProgramOptions
extends CommandLineOptions {
    private final String jarFilePath;
    private final String entryPointClass;
    private final String[] programArgs;
    private final int parallelism;

    protected ProgramOptions(CommandLine line) throws CliArgsException {
        block8: {
            String[] args;
            super(line);
            String[] stringArray = args = line.hasOption(CliFrontendParser.ARGS_OPTION.getOpt()) ? line.getOptionValues(CliFrontendParser.ARGS_OPTION.getOpt()) : line.getArgs();
            if (line.hasOption(CliFrontendParser.JAR_OPTION.getOpt())) {
                this.jarFilePath = line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt());
            } else if (args.length > 0) {
                this.jarFilePath = args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
            } else {
                this.jarFilePath = null;
            }
            this.programArgs = args;
            String string = this.entryPointClass = line.hasOption(CliFrontendParser.CLASS_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()) : null;
            if (line.hasOption(CliFrontendParser.PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(CliFrontendParser.PARALLELISM_OPTION.getOpt());
                try {
                    this.parallelism = Integer.parseInt(parString);
                    if (this.parallelism <= 0) {
                        throw new NumberFormatException();
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    throw new CliArgsException("The parallelism must be a positive number: " + parString);
                }
            }
            this.parallelism = -1;
        }
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getEntryPointClassName() {
        return this.entryPointClass;
    }

    public String[] getProgramArgs() {
        return this.programArgs;
    }

    public int getParallelism() {
        return this.parallelism;
    }
}

