/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.Plan;

public class JobWithJars {
    private Plan plan;
    private List<File> jarFiles;
    private ClassLoader userCodeClassLoader;

    public JobWithJars(Plan plan, List<String> jarFiles) throws IOException {
        this.plan = plan;
        this.jarFiles = new ArrayList<File>(jarFiles.size());
        for (String jar : jarFiles) {
            File file = new File(jar);
            JobWithJars.checkJarFile(file);
            this.jarFiles.add(file);
        }
    }

    public JobWithJars(Plan plan, String jarFile) throws IOException {
        this.plan = plan;
        File file = new File(jarFile);
        JobWithJars.checkJarFile(file);
        this.jarFiles = Collections.singletonList(file);
    }

    JobWithJars(Plan plan, List<File> jarFiles, ClassLoader userCodeClassLoader) {
        this.plan = plan;
        this.jarFiles = jarFiles;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public List<File> getJarFiles() {
        return this.jarFiles;
    }

    public ClassLoader getUserCodeClassLoader() {
        if (this.userCodeClassLoader == null) {
            this.userCodeClassLoader = JobWithJars.buildUserCodeClassLoader(this.jarFiles, this.getClass().getClassLoader());
        }
        return this.userCodeClassLoader;
    }

    public static void checkJarFile(File jar) throws IOException {
        if (!jar.exists()) {
            throw new IOException("JAR file does not exist '" + jar.getAbsolutePath() + "'");
        }
        if (!jar.canRead()) {
            throw new IOException("JAR file can't be read '" + jar.getAbsolutePath() + "'");
        }
    }

    public static ClassLoader buildUserCodeClassLoader(List<File> jars, ClassLoader parent) {
        URL[] urls = new URL[jars.size()];
        try {
            for (int i = 0; i < jars.size(); ++i) {
                urls[i] = jars.get(i).getAbsoluteFile().toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create class loader for program jar files: " + e.getMessage(), e);
        }
        return new URLClassLoader(urls, parent);
    }
}

